/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public class Graph
extends Canvas {
    protected int xStepSize;
    protected int xSizeOfUnit;
    protected int yStepSize;
    protected int ySizeOfUnit;
    protected int maxX;
    protected int maxY;
    protected int xSide;
    protected int ySide;
    protected int h;
    protected int w;
    protected int xZero;
    protected int yZero;
    protected int xMult;
    protected int yMult;
    protected int firstXMark;
    protected int firstYMark;
    protected int highX;
    protected int lowX;
    protected int highY;
    protected int lowY;
    static final Font defaultFont = new Font("Times", 0, 14);
    static FontMetrics fm;
    static final int fontHeight = 11;
    protected Vector plots;
    protected boolean useHighX = true;
    protected boolean useHighY = true;
    protected boolean useLowX = true;
    protected boolean useLowY = true;
    protected boolean useXStepSize = true;
    protected boolean useYStepSize = true;

    public Graph() {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Graph(int n, int n2, int n3, int n4, int n5, int n6) {
        this.highX = n2;
        this.lowX = n;
        this.xStepSize = n3;
        if (n == Integer.MAX_VALUE) {
            this.useLowX = false;
        }
        if (n2 == Integer.MAX_VALUE) {
            this.useHighX = false;
        }
        if (n3 == Integer.MAX_VALUE) {
            this.useXStepSize = false;
        }
        this.highY = n5;
        this.lowY = n4;
        this.yStepSize = n6;
        if (n4 == Integer.MAX_VALUE) {
            this.useLowY = false;
        }
        if (n5 == Integer.MAX_VALUE) {
            this.useHighY = false;
        }
        if (n6 == Integer.MAX_VALUE) {
            this.useYStepSize = false;
        }
        fm = this.getFontMetrics(defaultFont);
        this.ySide = fm.getHeight();
        this.setBackground(Color.white);
        this.plots = new Vector(5, 5);
        this.setForeground(Color.black);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        String string;
        int n3;
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        this.maxY = this.h - this.ySide;
        MaxMin maxMin = null;
        if (!(this.useHighX && this.useLowX && this.useHighY && this.useLowY)) {
            maxMin = this.getMaxMin();
        }
        if (!this.useHighX) {
            this.highX = (int)Math.round(maxMin.maxX + 0.49999999999999);
        }
        if (!this.useLowX) {
            this.lowX = (int)Math.round(maxMin.minX - 0.5);
        }
        if (!this.useHighY) {
            this.highY = (int)Math.round(maxMin.maxY + 0.49999999999999);
        }
        if (!this.useLowY) {
            this.lowY = (int)Math.round(maxMin.minY - 0.5);
        }
        double d = (double)this.maxY / ((double)this.highY - (double)this.lowY);
        this.yMult = 1;
        while (d < 17.5) {
            n3 = this.nextSize(this.yMult);
            d *= (double)n3 / (double)this.yMult;
            this.yMult = n3;
        }
        if (!this.useYStepSize) {
            this.yStepSize = this.yMult;
        }
        this.ySizeOfUnit = (int)Math.round(d - 0.5);
        this.xSide = fm.stringWidth(String.valueOf(this.lowY));
        n3 = fm.stringWidth(String.valueOf(this.highY));
        if (this.xSide < n3) {
            this.xSide = n3;
        }
        this.maxX = this.w - this.xSide;
        double d2 = (double)this.maxX / ((double)this.highX - (double)this.lowX);
        this.xMult = 1;
        while (d2 < 25.5) {
            n3 = this.nextSize(this.xMult);
            d2 *= (double)n3 / (double)this.xMult;
            this.xMult = n3;
        }
        if (!this.useXStepSize) {
            this.xStepSize = this.xMult;
        }
        this.xSizeOfUnit = (int)Math.round(d2 - 0.5);
        if (this.lowY <= 0 && this.highY >= 0) {
            this.yZero = this.h - this.ySide + this.maxY * this.lowY / (this.highY - this.lowY) - (this.maxY - this.maxY / this.ySizeOfUnit * this.ySizeOfUnit) / 2;
            string = "0";
            n2 = 0;
            while (n2 * this.yStepSize <= this.highY) {
                graphics.drawString(string, this.xSide - fm.stringWidth(string), this.yZero - n2 * this.yStepSize * this.ySizeOfUnit / this.yMult + 5);
                string = String.valueOf(++n2 * this.yStepSize);
            }
            this.firstYMark = this.yZero;
            n2 = 1;
            while (-n2 * this.yStepSize >= this.lowY) {
                this.firstYMark = this.yZero + n2 * this.yStepSize * this.ySizeOfUnit / this.yMult;
                string = String.valueOf(-n2 * this.yStepSize);
                graphics.drawString(string, this.xSide - fm.stringWidth(string), this.firstYMark + 5);
                ++n2;
            }
            this.firstYMark = this.h - this.ySide - this.firstYMark;
        } else {
            n = this.maxY;
            this.firstYMark = (this.maxY - n) / 2;
            n2 = 0;
            while (n2 * this.yStepSize <= this.highY - this.lowY) {
                string = String.valueOf(n2 * this.yStepSize + this.lowY);
                graphics.drawString(string, this.xSide - fm.stringWidth(string), this.h - this.firstYMark - this.ySide - n2 * this.yStepSize * this.ySizeOfUnit / this.yMult + 5);
                ++n2;
            }
        }
        if (this.lowX <= 0 && this.highX >= 0) {
            this.xZero = this.xSide - this.maxX * this.lowX / (this.highX - this.lowX) + (this.maxX - this.maxX / this.xSizeOfUnit * this.xSizeOfUnit) / 2;
            string = "0";
            graphics.drawLine(this.xZero, this.h - this.ySide, this.xZero, 0);
            n2 = 0;
            while (n2 * this.yStepSize * this.ySizeOfUnit / this.yMult <= this.maxY) {
                graphics.drawLine(this.xZero - 2, this.h - this.ySide - this.firstYMark - n2 * this.yStepSize * this.ySizeOfUnit / this.yMult, this.xZero + 2, this.h - this.ySide - this.firstYMark - n2 * this.yStepSize * this.ySizeOfUnit / this.yMult);
                ++n2;
            }
            n2 = 0;
            while (n2 * this.xStepSize <= this.highX) {
                graphics.drawString(string, n2 * this.xStepSize * this.xSizeOfUnit / this.xMult + this.xZero - fm.stringWidth(string) / 2, this.h);
                string = String.valueOf(++n2 * this.xStepSize);
            }
            this.firstXMark = this.xZero;
            n2 = 1;
            while (-n2 * this.xStepSize >= this.lowX) {
                string = String.valueOf(-n2 * this.xStepSize);
                this.firstXMark = this.xZero - n2 * this.xStepSize * this.xSizeOfUnit / this.xMult;
                graphics.drawString(string, this.firstXMark - fm.stringWidth(string) / 2, this.h);
                ++n2;
            }
            this.firstXMark -= this.xSide;
        } else {
            n2 = 0;
            while (n2 * this.xStepSize <= this.highX - this.lowX) {
                string = String.valueOf(n2 * this.xStepSize + this.lowX);
                graphics.drawString(string, this.xSide + n2 * this.xStepSize * this.xSizeOfUnit / this.xMult - fm.stringWidth(string) / 2, this.h);
                ++n2;
            }
            this.firstXMark = 0;
        }
        n = 0;
        while (n * this.yStepSize * this.ySizeOfUnit / this.yMult - this.firstYMark <= this.maxY) {
            n2 = 0;
            while (n2 * this.xStepSize * this.xSizeOfUnit / this.xMult + this.firstXMark <= this.maxX) {
                graphics.drawLine(this.xSide + n2 * this.xStepSize * this.xSizeOfUnit / this.xMult + this.firstXMark, this.h - this.ySide - n * this.yStepSize * this.ySizeOfUnit / this.yMult - this.firstYMark, this.xSide + n2 * this.xStepSize * this.xSizeOfUnit / this.xMult + this.firstXMark, this.h - this.ySide - n * this.yStepSize * this.ySizeOfUnit / this.yMult - this.firstYMark);
                ++n2;
            }
            ++n;
        }
        if (this.lowY <= 0 && this.highY >= 0) {
            graphics.drawLine(this.xSide, this.yZero, this.w, this.yZero);
            n2 = 0;
            while (n2 * this.xStepSize * this.xSizeOfUnit / this.xMult <= this.maxX) {
                graphics.drawLine(this.xSide + this.firstXMark + n2 * this.xStepSize * this.xSizeOfUnit / this.xMult, this.yZero - 2, this.xSide + this.firstXMark + n2 * this.xStepSize * this.xSizeOfUnit / this.xMult, this.yZero + 2);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.plots.size()) {
            this.draw((Plot)this.plots.elementAt(n2), graphics);
            ++n2;
        }
    }

    public void draw(Plot plot, Graphics graphics) {
        graphics.setColor(plot.getColor());
        switch (plot.getType()) {
            case 2: {
                int n = this.convertX(plot.getPeriod()) - this.xSide;
                Color color = plot.getColor().darker();
                int n2 = 0;
                int n3 = 0;
                int n4 = plot.size();
                DoublePoint doublePoint = (DoublePoint)plot.getDataPoint(0).clone();
                DoublePoint doublePoint2 = new DoublePoint();
                int n5 = 0;
                while (n2 < this.w) {
                    int n6;
                    int n7;
                    int n8 = 1;
                    while (n8 < n4 && n2 < this.w) {
                        doublePoint2.copy(doublePoint);
                        doublePoint.copy(plot.getDataPoint(n8));
                        n7 = this.convertX(doublePoint2.x) + n5 * n;
                        n2 = this.convertX(doublePoint.x) + n5 * n;
                        n6 = this.convertY(doublePoint2.y);
                        n3 = this.convertY(doublePoint.y);
                        graphics.drawLine(n7, n6, n2, n3);
                        graphics.setColor(color);
                        graphics.fillRect(n7 - 1, n6 - 1, 3, 3);
                        graphics.setColor(plot.getColor());
                        ++n8;
                    }
                    if (n2 >= this.w) break;
                    doublePoint2.copy(doublePoint);
                    doublePoint.copy(plot.getDataPoint(0));
                    n7 = this.convertX(doublePoint2.x) + n5 * n;
                    n2 = this.convertX(doublePoint.x) + (n5 + 1) * n;
                    n6 = this.convertY(doublePoint2.y);
                    n3 = this.convertY(doublePoint.y);
                    graphics.drawLine(n7, n6, n2, n3);
                    graphics.setColor(color);
                    graphics.fillRect(n7 - 1, n6 - 1, 3, 3);
                    graphics.setColor(plot.getColor());
                    ++n5;
                }
                graphics.setColor(color);
                graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
                graphics.setColor(plot.getColor());
                break;
            }
            case 0: {
                Color color = plot.getColor().darker();
                int n = 0;
                int n9 = 0;
                int n10 = plot.size();
                DoublePoint doublePoint = (DoublePoint)plot.getDataPoint(0).clone();
                DoublePoint doublePoint3 = new DoublePoint();
                int n11 = 1;
                while (n11 < n10) {
                    doublePoint3.copy(doublePoint);
                    doublePoint.copy(plot.getDataPoint(n11));
                    int n12 = this.convertX(doublePoint3.x);
                    n = this.convertX(doublePoint.x);
                    int n13 = this.convertY(doublePoint3.y);
                    n9 = this.convertY(doublePoint.y);
                    graphics.drawLine(n12, n13, n, n9);
                    graphics.setColor(color);
                    graphics.fillRect(n12 - 1, n13 - 1, 3, 3);
                    graphics.setColor(plot.getColor());
                    ++n11;
                }
                graphics.setColor(color);
                graphics.fillRect(n - 1, n9 - 1, 3, 3);
                graphics.setColor(plot.getColor());
                break;
            }
            case 1: {
                int n = this.xSide + 1;
                int n14 = this.convertY(plot.getValue(this.convertXBack(this.xSide)));
                while (n <= this.w) {
                    int n15 = this.convertY(plot.getValue(this.convertXBack(n)));
                    graphics.drawLine(n - 1, n14, n, n15);
                    n14 = n15;
                    ++n;
                }
                break;
            }
        }
    }

    public int convertX(double d) {
        return this.xSide + this.firstXMark + (int)((d - (double)this.lowX) * ((double)this.xSizeOfUnit / (double)this.xMult));
    }

    public int convertY(double d) {
        int n = this.h - this.firstYMark - this.ySide - (int)((d - (double)this.lowY) * (double)this.ySizeOfUnit / (double)this.yMult);
        if (n < -1) {
            return -1;
        }
        if (n > this.h + 1) {
            return this.h + 1;
        }
        return n;
    }

    public double convertXBack(int n) {
        return (double)((n - this.xSide) * this.xMult) / (double)this.xSizeOfUnit + (double)this.lowX;
    }

    public void addPlot(Plot plot) {
        this.plots.addElement(plot);
    }

    public void removePlot(Plot plot) {
        this.plots.removeElement(plot);
    }

    public void removeAll() {
        this.plots.removeAllElements();
    }

    public int getXMult() {
        return this.xMult;
    }

    public int getYMult() {
        return this.yMult;
    }

    protected MaxMin getMaxMin() {
        MaxMin maxMin = null;
        int n = 0;
        while (n < this.plots.size()) {
            MaxMin maxMin2 = ((Plot)this.plots.elementAt(n)).getMaxMin();
            if (maxMin == null) {
                maxMin = maxMin2;
            } else if (maxMin2 != null) {
                if (maxMin2.minX < maxMin.minX) {
                    maxMin.minX = maxMin2.minX;
                }
                if (maxMin2.maxX > maxMin.maxX) {
                    maxMin.maxX = maxMin2.maxX;
                }
                if (maxMin2.minY < maxMin.minY) {
                    maxMin.minY = maxMin2.minY;
                }
                if (maxMin2.maxY > maxMin.maxY) {
                    maxMin.maxY = maxMin2.maxY;
                }
            }
            ++n;
        }
        return maxMin;
    }

    protected int nextSize(int n) {
        int n2 = 1;
        while (n != 0) {
            if (n == 1) {
                return 2 * n2;
            }
            if (n == 2) {
                return 5 * n2;
            }
            if (n == 5) {
                return 10 * n2;
            }
            n /= 10;
            n2 *= 10;
        }
        return 0;
    }
}

