/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Plot {
    protected int type;
    protected DoublePoint[] data;
    protected double[] coef;
    protected double period;
    protected Color color;

    public Plot(DoublePoint[] doublePointArray, Color color) {
        this.type = 0;
        this.data = new DoublePoint[doublePointArray.length];
        int n = 0;
        while (n < this.data.length) {
            this.data[n] = (DoublePoint)doublePointArray[n].clone();
            ++n;
        }
        this.color = color;
    }

    public Plot(DoublePoint[] doublePointArray, Color color, double d) {
        this.type = 2;
        this.data = new DoublePoint[doublePointArray.length];
        int n = 0;
        while (n < this.data.length) {
            this.data[n] = (DoublePoint)doublePointArray[n].clone();
            ++n;
        }
        this.period = d;
        this.color = color;
    }

    private Plot(DoublePoint[] doublePointArray, Color color, boolean bl) {
        this.type = 0;
        this.data = doublePointArray;
        this.color = color;
    }

    private Plot(DoublePoint[] doublePointArray, Color color, double d, boolean bl) {
        this.type = 2;
        this.data = doublePointArray;
        this.period = d;
        this.color = color;
    }

    public Plot(double[] dArray, Color color) {
        this.type = 1;
        this.coef = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            this.coef[n] = dArray[n];
            ++n;
        }
        this.color = color;
    }

    public Plot(double[] dArray, Color color, boolean bl) {
        this.type = 1;
        this.coef = dArray;
        this.color = color;
    }

    public int getType() {
        return this.type;
    }

    public DoublePoint getDataPoint(int n) {
        return this.data[n];
    }

    public MaxMin getMaxMin() {
        if (this.type == 1) {
            return null;
        }
        MaxMin maxMin = new MaxMin();
        maxMin.minX = maxMin.maxX = this.data[0].x;
        maxMin.minY = maxMin.maxY = this.data[0].y;
        int n = 1;
        while (n < this.data.length) {
            if (maxMin.minX > this.data[n].x) {
                maxMin.minX = this.data[n].x;
            } else if (maxMin.maxX < this.data[n].x) {
                maxMin.maxX = this.data[n].x;
            }
            if (maxMin.minY > this.data[n].y) {
                maxMin.minY = this.data[n].y;
            } else if (maxMin.maxY < this.data[n].y) {
                maxMin.maxY = this.data[n].y;
            }
            ++n;
        }
        return maxMin;
    }

    public double getValue(double d) {
        double d2 = this.coef[this.coef.length - 1];
        int n = this.coef.length - 2;
        while (n >= 0) {
            d2 = this.coef[n] + d * d2;
            --n;
        }
        return d2;
    }

    public int size() {
        return this.data.length;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getPeriod() {
        return this.period;
    }

    public double[] getCoef() {
        return this.coef;
    }

    public Plot getSeason(double d, Color color) {
        int n;
        if (d <= 1.0E-12) {
            return new Plot(this.data, color, true);
        }
        int n2 = 1;
        while (this.data[n2].x - this.data[0].x != d) {
            ++n2;
        }
        if (n2 % 2 == 0) {
            int n3;
            int n4 = n2 / 2;
            double[] dArray = new double[this.data.length - n2];
            int n5 = n4;
            while (n5 + n4 < this.data.length) {
                dArray[n5 - n4] = this.data[n5].y;
                n3 = 1;
                while (n3 < n4) {
                    int n6 = n5 - n4;
                    dArray[n6] = dArray[n6] + (this.data[n5 - n3].y + this.data[n5 + n3].y);
                    ++n3;
                }
                int n7 = n5 - n4;
                dArray[n7] = dArray[n7] + (this.data[n5 - n3].y + this.data[n5 + n3].y) / 2.0;
                int n8 = n5 - n4;
                dArray[n8] = dArray[n8] / (double)n2;
                dArray[n5 - n4] = this.data[n5].y - dArray[n5 - n4];
                ++n5;
            }
            DoublePoint[] doublePointArray = new DoublePoint[n2];
            n3 = 0;
            while (n3 < n4) {
                doublePointArray[n3] = new DoublePoint(this.data[n3].x, 0.0);
                int n9 = 0;
                while (n3 + n4 + n9 * n2 < dArray.length) {
                    doublePointArray[n3].y += dArray[n3 + n4 + n9 * n2];
                    ++n9;
                }
                doublePointArray[n3].y /= (double)n9;
                ++n3;
            }
            int n10 = n4;
            while (n10 < n2) {
                doublePointArray[n10] = new DoublePoint(this.data[n10].x, 0.0);
                int n11 = 0;
                while (n10 - n4 + n11 * n2 < dArray.length) {
                    doublePointArray[n10].y += dArray[n10 - n4 + n11 * n2];
                    ++n11;
                }
                doublePointArray[n10].y /= (double)n11;
                ++n10;
            }
            double d2 = 0.0;
            int n12 = 0;
            while (n12 < n2) {
                d2 += doublePointArray[n12].y;
                ++n12;
            }
            d2 /= (double)n2;
            int n13 = 0;
            while (n13 < n2) {
                doublePointArray[n13].y -= d2;
                ++n13;
            }
            return new Plot(doublePointArray, color, d, true);
        }
        int n14 = (n2 - 1) / 2;
        double[] dArray = new double[this.data.length - n2 + 1];
        int n15 = n14;
        while (n15 + n14 < this.data.length) {
            dArray[n15 - n14] = this.data[n15].y;
            n = 1;
            while (n <= n14) {
                int n16 = n15 - n14;
                dArray[n16] = dArray[n16] + (this.data[n15 - n].y + this.data[n15 + n].y);
                ++n;
            }
            int n17 = n15 - n14;
            dArray[n17] = dArray[n17] / (double)n2;
            dArray[n15 - n14] = this.data[n15].y - dArray[n15 - n14];
            ++n15;
        }
        DoublePoint[] doublePointArray = new DoublePoint[n2];
        n = 0;
        while (n < n14) {
            doublePointArray[n] = new DoublePoint(this.data[n].x, 0.0);
            int n18 = 0;
            while (n + n14 + 1 + n18 * n2 < dArray.length) {
                doublePointArray[n].y += dArray[n + n14 + 1 + n18 * n2];
                ++n18;
            }
            doublePointArray[n].y /= (double)n18;
            ++n;
        }
        int n19 = n14;
        while (n19 < n2) {
            doublePointArray[n19] = new DoublePoint(this.data[n19].x, 0.0);
            int n20 = 0;
            while (n19 - n14 + n20 * n2 < dArray.length) {
                doublePointArray[n19].y += dArray[n19 - n14 + n20 * n2];
                ++n20;
            }
            doublePointArray[n19].y /= (double)n20;
            ++n19;
        }
        double d3 = 0.0;
        int n21 = 0;
        while (n21 < n2) {
            d3 += doublePointArray[n21].y;
            ++n21;
        }
        d3 /= (double)n2;
        int n22 = 0;
        while (n22 < n2) {
            doublePointArray[n22].y -= d3;
            ++n22;
        }
        return new Plot(doublePointArray, color, d, true);
    }

    public Plot deSeasonalize(Plot plot, Color color) {
        DoublePoint[] doublePointArray = new DoublePoint[this.data.length];
        int n = 0;
        while (n < doublePointArray.length) {
            int n2 = 0;
            while (n2 < plot.size() && n < doublePointArray.length) {
                doublePointArray[n] = new DoublePoint(this.data[n].x, this.data[n].y - plot.getDataPoint((int)n2).y);
                ++n2;
                ++n;
            }
        }
        return new Plot(doublePointArray, color, true);
    }

    public Plot subtract(Plot plot, Color color) {
        DoublePoint[] doublePointArray = new DoublePoint[this.data.length];
        int n = 0;
        while (n < doublePointArray.length) {
            doublePointArray[n] = new DoublePoint(this.data[n].x, this.data[n].y - plot.getValue(this.data[n].x));
            ++n;
        }
        return new Plot(doublePointArray, color, true);
    }

    public Plot leastSquaresFit(int n, Color color) {
        int n2;
        int n3;
        int n4;
        double[] dArray = new double[n + 1];
        double[][] dArrayArray = new double[n + 1][];
        int n5 = 0;
        while (n5 < n + 1) {
            dArrayArray[n5] = new double[n + 1];
            ++n5;
        }
        double[] dArray2 = new double[n + 1];
        double[] dArray3 = new double[2 * n + 1];
        int n6 = 0;
        while (n6 <= 2 * n) {
            dArray3[n6] = 0.0;
            int n7 = 0;
            while (n7 < this.data.length) {
                int n8 = n6;
                dArray3[n8] = dArray3[n8] + this.myPow(this.data[n7].x, n6);
                ++n7;
            }
            ++n6;
        }
        int n9 = 0;
        while (n9 <= n) {
            n4 = n9;
            while (n4 <= n) {
                dArrayArray[n9][n4] = dArray3[n9 + n4];
                ++n4;
            }
            ++n9;
        }
        n4 = 0;
        while (n4 <= n) {
            dArray2[n4] = 0.0;
            n3 = 0;
            while (n3 < this.data.length) {
                int n10 = n4;
                dArray2[n10] = dArray2[n10] + this.myPow(this.data[n3].x, n4) * this.data[n3].y;
                ++n3;
            }
            ++n4;
        }
        n3 = 0;
        while (n3 <= n) {
            int n11 = 0;
            while (n11 < n3) {
                double[] dArray4 = dArrayArray[n3];
                int n12 = n3;
                dArray4[n12] = dArray4[n12] - dArrayArray[n11][n3] * dArrayArray[n11][n3];
                ++n11;
            }
            dArrayArray[n3][n3] = Math.sqrt(dArrayArray[n3][n3]);
            n2 = n3 + 1;
            while (n2 <= n) {
                n11 = 0;
                while (n11 < n3) {
                    double[] dArray5 = dArrayArray[n3];
                    int n13 = n2;
                    dArray5[n13] = dArray5[n13] - dArrayArray[n11][n3] * dArrayArray[n11][n2];
                    ++n11;
                }
                dArrayArray[n3][n2] = dArrayArray[n3][n2] / dArrayArray[n3][n3];
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 <= n) {
            dArray[n2] = dArray2[n2];
            int n14 = 0;
            while (n14 < n2) {
                int n15 = n2;
                dArray[n15] = dArray[n15] - dArrayArray[n14][n2] * dArray[n14];
                ++n14;
            }
            int n16 = n2;
            dArray[n16] = dArray[n16] / dArrayArray[n2][n2];
            ++n2;
        }
        int n17 = n;
        while (n17 >= 0) {
            int n18 = n17 + 1;
            while (n18 <= n) {
                int n19 = n17;
                dArray[n19] = dArray[n19] - dArrayArray[n17][n18] * dArray[n18];
                ++n18;
            }
            int n20 = n17;
            dArray[n20] = dArray[n20] / dArrayArray[n17][n17];
            --n17;
        }
        return new Plot(dArray, color, true);
    }

    private double myPow(double d, int n) {
        double d2 = 1.0;
        int n2 = 1;
        while (n2 <= n) {
            d2 *= d;
            ++n2;
        }
        return d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: 
            case 2: {
                stringBuffer.append("Plot[type=" + this.type + ",\n");
                int n = 0;
                while (n < this.data.length) {
                    stringBuffer.append(n).append(":\t").append(this.data[n].toString()).append(",\n");
                    ++n;
                }
                stringBuffer.append(this.color).append("]");
                return stringBuffer.toString();
            }
            case 1: {
                stringBuffer.append("Plot[type=" + this.type + ",");
                int n = 0;
                while (n < this.coef.length) {
                    stringBuffer.append("coef[").append(n).append("]=").append(this.coef[n]).append(",");
                    ++n;
                }
                stringBuffer.append(this.color).append("]");
                return stringBuffer.toString();
            }
        }
        return "Plot[OOPS]";
    }
}

