// Author: Manfred Georg

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

// This class creates a graph of instances of Plot (Plot defines a set
// of data).  Any number of Plots can be used and color can be
// specified.

public class Graph extends Canvas {
  // xSize = xStepSize = what interval to put tick marks at
  //     2 means put marks at 2, 4, 6, 8, 10...
  //     3 means put marks at 3, 6, 9, 12...
  // xSizeOfUnit = number of pixels per amount of units specified by xMult
  // xMult = number of units per pixels specified in xUnit
  // firstXMark the space between the xSide and the first tick mark
  // ySize, ySizeOfUnit, yMult same for y-axis
  // yZero = the location of Zero on the screen in pixels (from top of course)
  // firstYMark the space between the ySide and the first tick mark (on the bot)
  // xSide = the amount of pixels of space between the y-axis and the side
  //      of the Graph.
  // ySide = space from bottom to where the drawing surface is
  // lowX = the lowest value of x shown
  // highX = the highest value of x shown
  // lowY, highY = same for y
  // use(High|Low)(X|Y) use the appropriete variable?

  protected int xStepSize, xSizeOfUnit, yStepSize, ySizeOfUnit,
                maxX, maxY;
  protected int xSide, ySide, h, w, xZero, yZero, xMult, yMult;
  protected int firstXMark, firstYMark; // what pixel the first make is on
  protected int highX, lowX, highY, lowY;
  static final Font defaultFont = new Font("Times",0,14);
  static FontMetrics fm;
  static final int fontHeight = 11; // the fm was giving too large a number
  protected Vector plots;
  protected boolean useHighX=true, useHighY=true, useLowX=true, useLowY=true,
                    useXStepSize=true, useYStepSize=true;

  // default constructor...just let it ajust everything

  public Graph() {
    this(Integer.MAX_VALUE,Integer.MAX_VALUE,Integer.MAX_VALUE,
         Integer.MAX_VALUE,Integer.MAX_VALUE,Integer.MAX_VALUE);
  }

  // this graph will resize itself to the space avalible and draw itself
  // trying to show all data
  // highX specifies the upper bound of X: Integer.MAX_VALUE means
  //       resize to plots maximum value
  // lowX same as above except for low value...note though still MAX_VALUE
  // xStepSize is the size of the step to use... MAX_VALUE=unspecified
  // highY, lowY, yStepSize...same for y

  public Graph(int lowX, int highX, int xStepSize,
               int lowY, int highY, int yStepSize) {
    super();

    this.highX = highX;
    this.lowX = lowX;
    this.xStepSize = xStepSize;
    if(lowX==Integer.MAX_VALUE)  // use... variables are initially true
      useLowX=false;
    if(highX==Integer.MAX_VALUE)
      useHighX=false;
    if(xStepSize==Integer.MAX_VALUE)
      useXStepSize=false;

    this.highY = highY;
    this.lowY = lowY;
    this.yStepSize = yStepSize;
    if(lowY==Integer.MAX_VALUE)
      useLowY=false;
    if(highY==Integer.MAX_VALUE)
      useHighY=false;
    if(yStepSize==Integer.MAX_VALUE)
      useYStepSize=false;

    fm = getFontMetrics(defaultFont);
    this.ySide = fm.getHeight();
    setBackground(Color.white);
    plots = new Vector(5,5);
    setForeground(Color.black);
  }

  public void paint(Graphics g) {
    int j;

    this.w = this.getSize().width; // this never seems to work
    this.h = this.getSize().height;
    maxY = h - ySide;

    //System.out.println("w = "+w+"\th = "+h);

    // find all the settings

    // ************** Remove mm things in fact only look at it if neccissary
    // amd then use highX... from then on.

    // could be written more effeciently...next line is not always neccissary
    MaxMin mm=null;
    if(!useHighX || !useLowX || !useHighY || !useLowY)
      mm = getMaxMin();
    if(!useHighX ) {
      highX = (int) Math.round(mm.maxX+.49999999999999d); // ceil
    }
    if(!useLowX ) {
      lowX = (int) Math.round(mm.minX-.5d); // floor
    }
    if(!useHighY ) {
      highY = (int) Math.round(mm.maxY+.49999999999999d); // ceil
    }
    if(!useLowY ) {
      lowY = (int) Math.round(mm.minY-.5d); // floor
    }

    //System.out.println("lowX = "+lowX+"\thighX = "+highX);
    //System.out.println("lowY = "+lowY+"\thighY = "+highY);

    // do Y first because it must set xSize and maxX
    double picsY = ((double)maxY)
                   / ( (double)highY-(double)lowY );
    int temp;
    yMult=1;
    while(picsY<17.5) {
      temp = nextSize(yMult);
      picsY *= ((double)temp) / ((double)yMult);
      yMult = temp;
    }

    if(!useYStepSize)
      yStepSize = yMult;
    ySizeOfUnit = (int)Math.round(picsY-.5d);

    xSide = fm.stringWidth(String.valueOf(lowY ));
    temp  = fm.stringWidth(String.valueOf(highY));
    if(xSide<temp)
      xSide=temp;

    maxX = w - xSide;

    // X

    double picsX = ((double)maxX)
                   / ( (double)highX-(double)lowX );

    xMult=1;
    while(picsX<25.5) {
      temp = nextSize(xMult);
      picsX *= ((double)temp) / ((double)xMult);
      xMult = temp;
    }

    if(!useXStepSize)
      xStepSize = xMult;
    xSizeOfUnit = (int)Math.round(picsX-.5d);

    //System.out.println("xSizeOfUnit = "+xSizeOfUnit);
    //System.out.println("ySizeOfUnit = "+ySizeOfUnit);

    // start drawing things

    //System.out.println("lowX = "+lowX+"\thighX = "+highX);
    //System.out.println("lowY = "+lowY+"\thighY = "+highY);

    String tmp;
    if(lowY<=0 && highY>=0) {
      yZero = h-ySide+((maxY*lowY)/(highY-lowY))- // remove half of extra space
                    (maxY-(maxY/ySizeOfUnit)*(ySizeOfUnit))/2;

      // start drawing strings
      tmp="0";
      for(j=0;j*yStepSize<=highY;) {
        g.drawString(tmp, xSide-fm.stringWidth(tmp),
                          yZero-j*yStepSize*ySizeOfUnit/yMult+fontHeight/2);
        tmp=String.valueOf(++j*yStepSize);
      }
      firstYMark=yZero; // in case there are no higher tick marks
      for(j=1;-j*yStepSize>=lowY;j++) {
        firstYMark=yZero+j*yStepSize*ySizeOfUnit/yMult;
        tmp=String.valueOf(-j*yStepSize);
        g.drawString(tmp, xSide-fm.stringWidth(tmp),
                          firstYMark+fontHeight/2);
      }
      firstYMark=h-ySide-firstYMark; // make it distance between bottom
                                     // of screen and lowest mark
    }
    else { // doesn't include zero
      int maxValue=maxY;
      // write numbers on y-axis
      firstYMark=(maxY-maxValue)/2; // begin with equal space on top and bottom
      for(j=0; j*yStepSize <= highY-lowY; j++) {
        tmp=String.valueOf(j*yStepSize+lowY);
        g.drawString(tmp, xSide-fm.stringWidth(tmp),
             h-firstYMark-ySide - j*yStepSize*ySizeOfUnit/yMult+fontHeight/2);
      }
    }
    if(lowX<=0 && highX>=0) {
      //System.out.println("zero must be included on x-axis");
      xZero = xSide - ((maxX*lowX)/(highX-lowX)) + // add half of extra space
                    (maxX-(maxX/xSizeOfUnit)*xSizeOfUnit)/2;
      //System.out.println("xZero = "+xZero);
      tmp="0";
      // make axis 
      g.drawLine(xZero,h-ySide,xZero,0);
      // make tick marks on axis
      for(j=0;j*yStepSize*ySizeOfUnit/yMult<=maxY;j++) {
        g.drawLine(xZero-2,h-ySide-firstYMark-j*yStepSize*ySizeOfUnit/yMult,
                   xZero+2,h-ySide-firstYMark-j*yStepSize*ySizeOfUnit/yMult);
      }
      for(j=0;j*xStepSize<=highX;) {
        g.drawString(tmp, j*xStepSize*xSizeOfUnit/xMult+xZero-
                          fm.stringWidth(tmp)/2,h);
        tmp=String.valueOf(++j*xStepSize);
      }
      firstXMark=xZero; // in case there are no lower tick marks
      for(j=1;-j*xStepSize>=lowX;j++) {
        tmp=String.valueOf(-j*xStepSize);
        firstXMark=xZero-j*xStepSize*xSizeOfUnit/xMult;
        g.drawString(tmp, firstXMark-fm.stringWidth(tmp)/2,h);
      }
      firstXMark -= xSide;
    }
    else { // doesn't include zero
      for(j=0; j*xStepSize <= highX-lowX; j++) {
        tmp=String.valueOf(j*xStepSize+lowX);
        g.drawString(tmp, xSide+j*xStepSize*xSizeOfUnit/xMult-
                         (fm.stringWidth(tmp)/2),h);
      }
      firstXMark=0; // begin right away
    }
    for(int i=0; (i*yStepSize*ySizeOfUnit/yMult-firstYMark)<=maxY; i++) {
      for(j=0; (j*xStepSize*xSizeOfUnit/xMult+firstXMark)<=maxX; j++) {
        g.drawLine((xSide+j*xStepSize*xSizeOfUnit/xMult+firstXMark),
                   (h-ySide-i*yStepSize*ySizeOfUnit/yMult-firstYMark),
                   (xSide+j*xStepSize*xSizeOfUnit/xMult+firstXMark),
	           (h-ySide-i*yStepSize*ySizeOfUnit/yMult-firstYMark) );
      }
    }
    if(lowY<=0 && highY>=0) { // didn't have enough information to do earlier
      // make axis 
      g.drawLine(xSide,yZero,w,yZero);
      // make tick marks on axis
      for(j=0;j*xStepSize*xSizeOfUnit/xMult<=maxX;j++) {
        g.drawLine(xSide+firstXMark+j*xStepSize*xSizeOfUnit/xMult,yZero-2,
                   xSide+firstXMark+j*xStepSize*xSizeOfUnit/xMult,yZero+2);
      }
    }
    for(j=0; j<plots.size() ; j++) {
      draw((Plot)plots.elementAt(j),g);
    }
  }
  
  public void draw(Plot p, Graphics g) {
    boolean repeat;
    g.setColor(p.getColor());
    switch(p.getType()) {
      case 2: // repeat
        {
          int period = convertX(p.getPeriod())-xSide;
          Color pointColor = p.getColor().darker();
          DoublePoint p1, p2;
          int x1c,x2c=0,y1c,y2c=0;
          int max = p.size();
          p2 = (DoublePoint)p.getDataPoint(0).clone();
          p1 = new DoublePoint();
          big: for(int j=0; x2c<w; j++ ) {
            for(int i=1;i<max && x2c<w;i++) {
              p1.copy(p2);
              p2.copy(p.getDataPoint(i));
              x1c = convertX(p1.x)+j*period;
              x2c = convertX(p2.x)+j*period;
              y1c = convertY(p1.y);
              y2c = convertY(p2.y);
              g.drawLine(x1c,y1c,x2c,y2c);
              g.setColor(pointColor);
              g.fillRect(x1c-1,y1c-1,3,3);
              g.setColor(p.getColor());
            }
            if(x2c>=w)
              break;
            p1.copy(p2);
            p2.copy(p.getDataPoint(0));
            x1c = convertX(p1.x)+j*period;
            x2c = convertX(p2.x)+(j+1)*period;
            y1c = convertY(p1.y);
            y2c = convertY(p2.y);
            g.drawLine(x1c,y1c,x2c,y2c);
            g.setColor(pointColor);
            g.fillRect(x1c-1,y1c-1,3,3);
            g.setColor(p.getColor());
          }
          g.setColor(pointColor);
          g.fillRect(x2c-1,y2c-1,3,3);
          g.setColor(p.getColor());
        }
        break;
      case 0:
        {
          Color pointColor = p.getColor().darker();
          DoublePoint p1, p2;
          int x1c,x2c=0,y1c,y2c=0;
          int max = p.size();
          p2 = (DoublePoint)p.getDataPoint(0).clone();
          p1 = new DoublePoint();
          for(int i=1;i<max;i++) {
            p1.copy(p2);
            p2.copy(p.getDataPoint(i));
            x1c = convertX(p1.x);
            x2c = convertX(p2.x);
            y1c = convertY(p1.y);
            y2c = convertY(p2.y);
            g.drawLine(x1c,y1c,x2c,y2c);
            g.setColor(pointColor);
            g.fillRect(x1c-1,y1c-1,3,3);
            g.setColor(p.getColor());
          }
          g.setColor(pointColor);
          g.fillRect(x2c-1,y2c-1,3,3);
          g.setColor(p.getColor());
        }
        break;
      case 1:
        for(int x=xSide+1, y1=convertY(p.getValue(convertXBack(xSide))),y2;
            x <= w; x++) { // draw every point
          //System.out.println("convertX(convertXBack("+x+")="+convertXBack(x)+") = "+convertX(convertXBack(x)));
          //System.out.println("convertY(p.getValue(convertXBack("+x+")="+convertXBack(x)+")="+p.getValue(convertXBack(x))+") = "+convertY(p.getValue(convertXBack(x))));
          y2 = convertY(p.getValue(convertXBack(x)));
          g.drawLine(x-1,y1,x,y2);
          y1 = y2;
        }
        break;
    }
  }

  public int convertX(double x) {
    return   (xSide+firstXMark+
               (int)((x-(double)lowX)*((double)xSizeOfUnit/(double)xMult)));
  }
  public int convertY(double y) {
    int result = h-firstYMark-ySide-
                   (int)((y-(double)lowY)*((double)ySizeOfUnit)/(double)yMult);
    if(result < -1)
      return -1;
    if(result > h+1)
      return h+1;
    return result;
  }

  public double convertXBack(int x) { // convert back
    return (((double)((x-xSide)*xMult))/((double)xSizeOfUnit)+(double)lowX);
  }

  public void addPlot(Plot p) {
    plots.addElement(p);
  }

  public void removePlot(Plot p) {
    plots.removeElement(p);
  }

  public void removeAll() {
    plots.removeAllElements();
  }

  public int getXMult() {
    return xMult;
  }

  public int getYMult() {
    return yMult;
  }

  protected MaxMin getMaxMin() {
    MaxMin mm, out;
    out=null;
    //System.out.println("getMaxMin() in Graph");
    for(int i=0; i<plots.size() ; i++) {
      mm = ((Plot)plots.elementAt(i)).getMaxMin();

      //System.out.println("getting size of plot "+i+" = "+mm);

      //System.out.println("out = "+out+"\nmm = "+mm);

      if(out == null) {
        out = mm;
      }
      else {
        if(mm != null) {
          if(mm.minX<out.minX) {
            //System.out.println("minX reset");
            out.minX = mm.minX;
          }
          if(mm.maxX>out.maxX) {
            //System.out.println("maxX reset");
            out.maxX = mm.maxX;
          }
          if(mm.minY<out.minY) {
            //System.out.println("minY reset");
            out.minY = mm.minY;
          }
          if(mm.maxY>out.maxY) {
            //System.out.println("maxY reset");
            out.maxY = mm.maxY;
          }
        }
      }
      
    }
    //System.out.println("out at end = "+out);
    return out;
  }

  protected int nextSize(int x) {
    for(int i=1;x!=0;i*=10) {
      if(x == 1)
        return 2*i;
      else if(x == 2)
        return 5*i;
      else if(x == 5)
        return 10*i;
      else
        x/=10;
    }

    return 0;
  }

}









