import java.applet.Applet;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;

public class plotgem_02 extends Applet {
	
	/****************************************************************************************/
	/* The following section sets up the gui                                                */
	/****************************************************************************************/
	public Graph g1,g2;
	public Plot p1,p2,p3,p4,p5,p6,p7,p8,p9,p10;
	public Checkbox CB_crit, CB_smooth, CB_exact, CB_asymp, CB_header,CB_strat;
	public CheckboxGroup CBGg;
	
	public Choice C_attr, C_strat;
	public TextArea TA_in,TA_out,TA_nnn;
	public TextField[] TF_inputs;
	public TextField TF_nnn,TF_nn2;
	public Label[] L_labels, L_spaces,L_key;
	public Button B_go, B_graph, B_read, B_clear;
	public String[] attr_key;
	public String[][] strat_key;
	public String strat_name;
	public double[][] covs,mydata;
	public double[][][] ci;
	public int[] nn;
	public double[] input_old,xxx;
	public DoublePoint[] dp1,dp2,dp3,dp4,dp5,dp6,dp7,dp8,dp9,dp10,dp11;
	public double CCC,ymax,ycrit,alpha,ymin,ci_min,ci_max,oldcrit;
	public int npsu,nsub,nsim,tstrata,tattr,nattr,nstrata,min_si,max_si,step_si,n_si,nrows,ncols,NNN;
	public boolean changed_inputs[], goodtogo, doboot,newsize,no_print,newdata;
	
	public GridBagConstraints c;
	
	public void init() {
		
		this.setLayout(new GridBagLayout());
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		Font f1 = new Font("Monospaced", Font.PLAIN, 11);
		Font f2 = new Font("Serif", Font.PLAIN, 11);
		Font f3 = new Font("Dialog", Font.PLAIN, 11);
		no_print=false;
		oldcrit=-1;
		alpha=.05;
		attr_key = new String[500];
		doboot=true;
		goodtogo=false;
		nsub=0;
		npsu=0;
		nrows=0;
		ncols=0;
		alpha=.05;
		newdata=true;
		covs = new double[500][10000];
		nn = new int[500];
		xxx = new double[10000];
		CCC=0;
		ci_min=0;
		ci_max=100;
		ymax=100;
		ymin=0;
		ycrit=20;
		boolean B_temp=true;
		tattr=-1;
		tstrata=-1;
		input_old = new double[7];
		for(int i=0;i<input_old.length;i++){input_old[i]=-1;}
		
		TA_in = new TextArea(12,1);
		TA_out = new TextArea(12,1);
		TA_nnn = new TextArea(1,1);
		
		TF_inputs = new TextField[100];
		TF_nnn = new TextField("");
		TF_nn2 = new TextField("");
		
		L_labels = new Label[100];
		L_spaces = new Label[500];
		L_key    = new Label[4];
		
		L_key[0]=new Label("Current Attribute = ",0);
		L_key[1]=new Label("                    ",0);L_key[1].setForeground(Color.red);
		L_key[2]=new Label("Current Stratum = ",0);
		L_key[3]=new Label("                  ",0);L_key[3].setForeground(Color.red);
		
		L_labels[0] = new Label("|--------- Bootstrap  Parameters --------|",1);		
		L_labels[1] = new Label("Number of Attributes = ",0);
		L_labels[2] = new Label("Number of Strata = ",0);
		L_labels[3] = new Label("Number of PSU\'s = ",0);
		L_labels[4] = new Label("Number of Subplots per PSU = ",0);
			
		L_labels[5] = new Label("Minimum Sampling Intensity = ");
		L_labels[6] = new Label("Maximum Sampling Intensity = ");
		L_labels[7] = new Label("Sampling Intensity Step Size = ");
		L_labels[8] = new Label("Number of Simulations = ",0);	
		L_labels[9] = new Label("Acceptable Percent Error = ");
		L_labels[10] = new Label("CI Confidence Level (1-alpha) = ");
		L_labels[11] = new Label("Stratum = ");
		L_labels[12] = new Label("Attribute = ");
		
		L_labels[13] = new Label("",1);//first line of title for % error graph
		L_labels[14] = new Label("",1);//second line of title for % error graph
		L_labels[15] = new Label("",1);//first line of title for ci graph
		L_labels[16] = new Label("",1);//second line of title for ci graph
		
		L_labels[17] = new Label(" ",1);
		L_labels[18] = new Label(" ",1);
		L_labels[19] = new Label("%",1);
		L_labels[20] = new Label(" ",1);
		L_labels[21] = new Label("e",1);
		L_labels[22] = new Label("r",1);
		L_labels[23] = new Label("r",1);
		L_labels[24] = new Label("o",1);
		L_labels[25] = new Label("r",1);
		L_labels[26] = new Label(" ",1);
		L_labels[27] = new Label(" ",1);
		
		L_labels[28] = new Label("c",1);
		L_labels[29] = new Label("i",1);
		L_labels[30] = new Label(" ",1);
		L_labels[31] = new Label("b",1);
		L_labels[32] = new Label("o",1);
		L_labels[33] = new Label("u",1);
		L_labels[34] = new Label("n",1);
		L_labels[35] = new Label("d",1);
		L_labels[36] = new Label("s",1);
		
		L_labels[37] = new Label("Sampling Intensity (Number of PSU\'s)",1);
		L_labels[38] = new Label("Sampling Intensity (Number of PSU\'s)",1);
		L_labels[39] = new Label("Sample size needed to achieve individual acceptable errors = ");
		L_labels[40] = new Label("Sample size needed to achieve acceptable error for the current attribute = ");
		L_labels[41] = new Label("Minimum sample size needed to achieve all acceptable errors = ");
		L_labels[42] = new Label("\\/------------------ paste plot data below ------------------\\/",1);
		L_labels[43] = new Label("\\/------------------- output appears below ------------------\\/",1);

		for(int i=0;i<44;i++){
			L_labels[i].setFont(f2);
			if(i<4){L_key[i].setFont(f2);}
		}
			
		TF_inputs[0] = new TextField("48");//nattr
		TF_inputs[3] = new TextField("4");//nsub
		TF_inputs[4] = new TextField("10");//nsim
		TF_inputs[5] = new TextField("400");//max_si
		TF_inputs[6] = new TextField("10");//step_si
		TF_inputs[7] = new TextField("50");//nsim
		TF_inputs[8] = new TextField("20");//% error
		TF_inputs[9]= new TextField(".95");//alpha

		
		c.gridx=0; c.gridy=1; c.gridwidth=3; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		this.add(L_labels[0],c);
		
		
		c.gridx=0; c.gridy=2; c.gridwidth=3; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		CB_header = new Checkbox("Column headings present?",true);
		CB_header.setFont(f2);
		CB_header.setForeground(Color.black);
		this.add(CB_header,c);
		

		c.gridx=0; c.gridy=3; c.gridwidth=2; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		this.add(L_labels[4],c);
		
		c.gridx=2; c.gridy=3; c.gridwidth=1; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		this.add(TF_inputs[3],c);

		
		
		
		B_read = new Button("Read Data");
		c.gridx=0; c.gridy=4; c.gridwidth=3; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		B_read.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				plotnothing();
				TA_in.setSelectionStart(0);
				TA_in.setSelectionEnd(0);
				mydata=getdata();
				newdata=true;				
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		});
		this.add(B_read,c);
		
		
		B_clear = new Button("Clear Data");
		c.gridx=0; c.gridy=5; c.gridwidth=3; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		B_clear.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				plotnothing();
				TA_out.setText("");
				TA_in.setText("");
				TA_in.setSelectionStart(0);
				TA_in.setSelectionEnd(0);
				C_strat.removeAll();
				C_attr.removeAll();
				newdata=true;				
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		});
		this.add(B_clear,c);
		
		for(int i=0;i<6;i++){
			c.gridx=0; c.gridy=i+7; c.gridwidth=2; c.gridheight=1;
			c.weightx = c.weighty = 0.0;
			this.add(L_labels[i+5],c);
			
			c.gridx=2; c.gridy=i+7; c.gridwidth=1; c.gridheight=1;
			c.weightx = c.weighty = 0.0;
			this.add(TF_inputs[i+4],c);
		}
		

		c.gridx=0; c.gridy=13; c.gridwidth=1; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		this.add(L_labels[11],c);

		C_strat = new Choice();
		C_strat.add(" ");
		c.gridx=1; c.gridy=13; c.gridwidth=2; c.gridheight=1;
        c.weightx=c.weighty=0.0;
        this.add(C_strat,c);
			
		c.gridx=0; c.gridy=14;c.gridwidth=1; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		this.add(L_labels[12],c);
		
		C_attr = new Choice();
		C_attr.add(" ");
		c.gridx=1; c.gridy=14; c.gridwidth=2; c.gridheight=1;
        c.weightx=c.weighty=0.0;
        this.add(C_attr,c);

		B_graph = new Button("Plot Curve");
		c.gridx=0; c.gridy=15; c.gridwidth=3; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		B_graph.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				if(goodtogo){
					tstrata=find_strat();
					tattr=find_attr();
					boolean goodparms = read_parms2();
					if((newdata  || doboot) && goodparms){
						plotnothing();
						boot(mydata);
						print_allsizes();
						if(!no_print || newdata){make_output();}
						if(n_si>1){plotgraph();}
						newdata=false;
					}
					else if(!doboot && goodparms){
						print_allsizes();
						if(!no_print || newdata){make_output();}
						if(n_si>1){plotgraph();}
						newdata=false;
								
					}
					else{
						plotnothing();
					}
					validate();
				}
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		});
		this.add(B_graph,c);
		
		
		
		
		for(int i=0;i<11;i++){
			c.gridx=4; c.gridy=i+1; c.gridwidth=1; c.gridheight=1;
			c.weightx = c.weighty = 0.0;
			this.add(L_labels[i+17],c);
		}
		

		c.gridx=5; c.gridy=0; c.gridwidth=8; c.gridheight=1;
		c.weightx = 0; c.weighty = 0;
		this.add(L_labels[13],c);
		c.gridx=5; c.gridy=1; c.gridwidth=8; c.gridheight=1;
		c.weightx = 0; c.weighty = 0;
		this.add(L_labels[14],c);
		c.gridx=14; c.gridy=0; c.gridwidth=10; c.gridheight=1;
		c.weightx = 0; c.weighty = 0;
		this.add(L_labels[15],c);
		c.gridx=14; c.gridy=1; c.gridwidth=10; c.gridheight=1;
		c.weightx = 0; c.weighty = 0;
		this.add(L_labels[16],c);

		g1 = new Graph(Integer.MAX_VALUE,Integer.MAX_VALUE,Integer.MAX_VALUE,(int)Math.floor(ymin),(int)Math.floor(ymax),Integer.MAX_VALUE);
		c.gridx=5; c.gridy=2; c.gridwidth=8; c.gridheight=9;
		c.weightx = 0; c.weighty = 0;
		this.add(g1,c);
		
		
		for(int i=0;i<9;i++){
			c.gridx=13; c.gridy=i+2; c.gridwidth=1; c.gridheight=1;
			c.weightx = c.weighty = 0.0;
			this.add(L_labels[i+28],c);
		}
		
		g2 = new Graph(Integer.MAX_VALUE,Integer.MAX_VALUE,Integer.MAX_VALUE,(int)Math.floor(ci_min),(int)Math.floor(ci_max),Integer.MAX_VALUE);
		c.gridx=14; c.gridy=2; c.gridwidth=10; c.gridheight=9;
		c.weightx = 0; c.weighty = 0;
		this.add(g2,c);
		
		
		c.gridx=5; c.gridy=11; c.gridwidth=8; c.gridheight=1;
		c.weightx =0; c.weighty = 0.0;
		this.add(L_labels[37],c);
		
		c.gridx=14; c.gridy=11; c.gridwidth=10; c.gridheight=1;
		c.weightx =0; c.weighty = 0.0;
		this.add(L_labels[38],c);
		
		c.gridx=5; c.gridy=12; c.gridwidth=1; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		CB_exact = new Checkbox("exact curve",true);
		CB_exact.setFont(f2);
		CB_exact.setForeground(Color.black);
		CB_exact.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				placegraphs();
			}
		});
		this.add(CB_exact,c);
		c.gridx=5; c.gridy=13; c.gridwidth=1; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		CB_smooth = new Checkbox("smoothed exact curve",true);
		CB_smooth.setFont(f2);
		CB_smooth.setForeground(Color.blue);
		CB_smooth.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				placegraphs();
			}
		});
		this.add(CB_smooth,c);
		c.gridx=5; c.gridy=14; c.gridwidth=1; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		CB_asymp = new Checkbox("asymptotic curve",true);
		CB_asymp.setFont(f2);
		CB_asymp.setForeground(Color.green);
		CB_asymp.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				placegraphs();
			}
		});
		this.add(CB_asymp,c);
		c.gridx=5; c.gridy=15; c.gridwidth=1; c.gridheight=1;
		c.weightx = c.weighty = 0.0;
		CB_crit = new Checkbox("acceptible error",true);
		CB_crit.setFont(f2);
		CB_crit.setForeground(Color.red);
		CB_crit.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				placegraphs();
			}
		});
		this.add(CB_crit,c);

		
		c.gridx=6; c.gridy=12; c.gridwidth=13; c.gridheight=1;
		c.weightx =0.0; c.weighty = 0.0;
		this.add(L_labels[39],c);
		TA_nnn.setFont(f1);
		c.gridx=19; c.gridy=12; c.gridwidth=5; c.gridheight=2;
		c.weightx=0; c.weighty=0.0;
		this.add(TA_nnn,c);
		c.gridx=6; c.gridy=14; c.gridwidth=13; c.gridheight=1;
		c.weightx =0; c.weighty = 0.0;
		this.add(L_labels[40],c);
		TF_nn2.setFont(f1);
		c.gridx=19; c.gridy=14; c.gridwidth=5; c.gridheight=1;
		c.weightx=0.0; c.weighty=0.0;
		this.add(TF_nn2,c);
		c.gridx=6; c.gridy=15; c.gridwidth=13; c.gridheight=1;
		c.weightx =0; c.weighty = 0.0;
		this.add(L_labels[41],c);
		TF_nnn.setFont(f1);
		c.gridx=19; c.gridy=15; c.gridwidth=5; c.gridheight=1;
		c.weightx=0.0; c.weighty=0.0;
		this.add(TF_nnn,c);
		
		
		for(int i=0;i<21;i++){
			L_spaces[i] = new Label("     ");
			c.gridx=i+3; c.gridy=16; c.gridwidth=1; c.gridheight=1;
			c.weightx = c.weighty = 0.0;
			this.add(L_spaces[i],c);
		}

		c.gridx=0; c.gridy=17; c.gridwidth=8; c.gridheight=1;
		c.weightx=0; c.weighty=0;
		this.add(L_labels[42],c);

		
		TA_in.setFont(f1);
		c.gridx=0; c.gridy=18; c.gridwidth=8; c.gridheight=20;
		c.weightx=0; c.weighty=0;
		this.add(TA_in,c);
		
		c.gridx=8; c.gridy=17; c.gridwidth=16; c.gridheight=1;
		c.weightx=0; c.weighty=0;
		this.add(L_labels[43],c);
		
		TA_out.setFont(f1);
		c.gridx=8; c.gridy=18; c.gridwidth=16; c.gridheight=20;
		c.weightx=0; c.weighty=0;
		this.add(TA_out,c);
		
	}
	
	/****************************************************************************************/
	/* ERROR CHECK INPUTS FOR SIMULATION PARAMETERS BEFORE INPUTING DATA                    */
	/****************************************************************************************/
	
	public boolean errorcheck_1(){
		boolean keepgoing = true;
		if(nsub<1){keepgoing=false;TF_inputs[3].setText("???");}
		return(keepgoing);
	}
	
	/****************************************************************************************/
	/* ERROR CHECK DATA INPUT BEFORE RUNNING SIMULATION                                     */
	/****************************************************************************************/
	
	public boolean errorcheck_2(){
		boolean keepgoing = true;
		if(nsub<1){keepgoing=false;TF_inputs[3].setText("???");}
		return(keepgoing);
	}
				
	
	/****************************************************************************************/
	/* READ IN THE SIMULATION PARAMETERS                                                    */
	/****************************************************************************************/
	
	/*	TF_inputs[0] = new TextField("48  ");//nattr
		TF_inputs[1] = new TextField("56  ");//nstrata
		TF_inputs[2] = new TextField("381 ");//npsu
		TF_inputs[3] = new TextField("4   ");//nsub
	*/
	
	public boolean read_parms1(){
		boolean keepgoing=true;
		double temp2=0;
		//nattr
		/*try{
			nattr = (int)Double.valueOf(TF_inputs[0].getText().trim()).doubleValue();
			temp2 = Double.valueOf(TF_inputs[0].getText().trim()).doubleValue();
		}catch(NumberFormatException nfe){nattr=-1;TF_inputs[0].setText("???");keepgoing=false;}
		if(keepgoing && temp2!=Math.floor(temp2)){nattr=-1;keepgoing=false;TF_inputs[0].setText("???");}
		*/
		//nsub
		if(keepgoing){
			try{
				nsub = (int)Double.valueOf(TF_inputs[3].getText().trim()).doubleValue();
				temp2 = Double.valueOf(TF_inputs[3].getText().trim()).doubleValue();
			}catch(NumberFormatException nfe){nsub=-1;TF_inputs[3].setText("???");keepgoing=false;}
		}
		if(keepgoing && temp2!=Math.floor(temp2)){nsub=-1;keepgoing=false;TF_inputs[3].setText("???");}
		return(keepgoing);
	}	
	/****************************************************************************************/
	/* READ IN THE SIMULATION PARAMETERS                                                    */
	/****************************************************************************************/
	/*	
		TF_inputs[4] = new TextField("10  ");//nsim
		TF_inputs[5] = new TextField("400 ");//max_si
		TF_inputs[6] = new TextField("10  ");//step_si
		TF_inputs[7] = new TextField("10  ");//nsim
		TF_inputs[8] = new TextField("20  ");//% error
		TF_inputs[9]= new TextField("1   ");//1-alpha
	*/
	public boolean read_parms2(){
		boolean keepgoing=true;
		double temp2=0;
		//min_si
		if(keepgoing){
			try{
				min_si = (int)Double.valueOf(TF_inputs[4].getText().trim()).doubleValue();
				temp2 = Double.valueOf(TF_inputs[4].getText().trim()).doubleValue();
			}catch(NumberFormatException nfe){min_si=-1;TF_inputs[4].setText("???");keepgoing=false;}
		}
		if(keepgoing && temp2!=Math.floor(temp2)){min_si=-1;keepgoing=false;TF_inputs[4].setText("???");}
		//max_si
		if(keepgoing){
			try{
				max_si = (int)Double.valueOf(TF_inputs[5].getText().trim()).doubleValue();
				temp2 = Double.valueOf(TF_inputs[5].getText().trim()).doubleValue();
			}catch(NumberFormatException nfe){max_si=-1;TF_inputs[5].setText("???");keepgoing=false;}
		}
		if(keepgoing && temp2!=Math.floor(temp2)){max_si=-1;keepgoing=false;TF_inputs[5].setText("???");}
		else if(max_si<min_si){min_si=-1;max_si=-1;keepgoing=false;TF_inputs[4].setText("???");TF_inputs[5].setText("???");}
		//step_si
		if(keepgoing){
			try{
				step_si = (int)Double.valueOf(TF_inputs[6].getText().trim()).doubleValue();
				temp2 = Double.valueOf(TF_inputs[6].getText().trim()).doubleValue();
			}catch(NumberFormatException nfe){step_si=-1;TF_inputs[6].setText("???");keepgoing=false;}
		}
		if(keepgoing && temp2!=Math.floor(temp2)){step_si=-1;keepgoing=false;TF_inputs[6].setText("???");}
		if(keepgoing && (double)(max_si-min_si)==0 && step_si!=0){step_si=-1;keepgoing=false;TF_inputs[6].setText("???");}
		if(keepgoing && min_si<max_si && step_si==0){step_si=-1;keepgoing=false;TF_inputs[6].setText("???");}
		if(step_si!=0){
			while(keepgoing && ((double)max_si-(double)min_si)/(double)step_si!=Math.floor(((double)max_si-(double)min_si)/(double)step_si)){
				max_si++;
			}
		}
		if(keepgoing){TF_inputs[5].setText(Integer.toString(max_si));}
		//nsim
		if(keepgoing){
			try{
				nsim = (int)Double.valueOf(TF_inputs[7].getText().trim()).doubleValue();
				temp2 = Double.valueOf(TF_inputs[7].getText().trim()).doubleValue();
			}catch(NumberFormatException nfe){nsim=-1;TF_inputs[7].setText("???");keepgoing=false;}
		}
		if(keepgoing && temp2!=Math.floor(temp2)){nsim=-1;keepgoing=false;TF_inputs[7].setText("???");}
		if(keepgoing && nsim<2){nsim=-1;keepgoing=false;TF_inputs[7].setText("???");}
		//ycrit
		if(keepgoing){
			try{
				ycrit = (int)Double.valueOf(TF_inputs[8].getText().trim()).doubleValue();
				temp2 = Double.valueOf(TF_inputs[8].getText().trim()).doubleValue();
			}catch(NumberFormatException nfe){ycrit=-1;TF_inputs[8].setText("???");keepgoing=false;}
			if(ycrit<0){oldcrit=ycrit;newsize=true;keepgoing=false;}
			else if(ycrit!=oldcrit){newsize=true;oldcrit=ycrit;}
			else{newsize=false;}
		}
		if(keepgoing && temp2!=Math.floor(temp2)){ycrit=-1;keepgoing=false;TF_inputs[9].setText("???");}
		//find out the number of points in each plot
		if(keepgoing){
			if(step_si==0){n_si=1;}
			else{
				double temp = (double)(max_si-min_si)/(double)step_si;
				n_si=(int)temp+1;
				if(temp!=Math.floor(temp)){max_si=min_si+step_si*n_si;}
			}
		}
		//alpha
		if(keepgoing){
			try{
				alpha = 1-Double.valueOf(TF_inputs[9].getText().trim()).doubleValue();
			}catch(NumberFormatException nfe){alpha=.05;TF_inputs[9].setText("???");keepgoing=false;}
		}
		if(keepgoing && (alpha<=0 || alpha>=1)){alpha=.05;keepgoing=false;TF_inputs[9].setText("???");}
		//determine if there were changes
		doboot=false;
		no_print=false;
		if(keepgoing){
			if(input_old[0]==(double)min_si && input_old[1]==(double)max_si && input_old[2]==(double)step_si &&
				input_old[3]==(double)nsim && input_old[4]==(double)find_strat() && input_old[5]==alpha &&
				input_old[6]==(double)find_attr()){no_print=true;}
			if(input_old[0]!=(double)min_si){doboot=true;}
			input_old[0]=(double)min_si;
			if(input_old[1]!=(double)max_si){doboot=true;}
			input_old[1]=(double)max_si;
			if(input_old[2]!=(double)step_si){doboot=true;}
			input_old[2]=(double)step_si;
			if(input_old[3]!=(double)nsim){doboot=true;}
			input_old[3]=(double)nsim;
			if(input_old[4]!=(double)find_strat()){doboot=true;}
			input_old[4]=(double)find_strat();
			if(input_old[5]!=alpha){doboot=true;}
			input_old[5]=alpha;
			input_old[6]=(double)find_attr();
		}
		if(!keepgoing){plotnothing();}
		return(keepgoing);
		
	}

	
	/****************************************************************************************/
	/* MAKE OUTPUT WINDOW -- E.G. DESCRIPTIVE STATISTICS                                    */
	/****************************************************************************************/
	public void make_output(){
		int dot;
		String temp1;
		double temp_ave=0;
		double temp_25th=0;
		double temp_75th=0;
		double temp_std=0;
		double temp_max=-1;
		double temp_min=100000000;
		double temp_med=0;
		double[] temp_all= new double[mydata.length];
		int temp_num=0;
		double temp_count=0;
		for(int i=0;i<mydata.length;i++){
			if((int)mydata[i][1]==tstrata){
				if(mydata[i][tattr+1]!=-1){
					temp_ave=temp_ave+mydata[i][tattr+1];
					temp_all[(int)temp_count]=mydata[i][tattr+1];
					temp_count++;
				}
			}
		}
		NNN=(int)temp_count;
		if(temp_count>0){
			temp_ave=temp_ave/temp_count;
			double[] temp_all2 = new double[(int)temp_count];
			for(int i=0;i<(int)temp_count;i++){
				temp_all2[i]=temp_all[i];
				temp_std=temp_std+Math.pow(temp_all[i]-temp_ave,2);
			}
			temp_std=Math.sqrt(temp_std/(temp_count-1));
			temp_all2 = slowsort(temp_all2);
			temp_min=temp_all2[temp_all2.length-1];
			temp_max=temp_all2[0];
			temp_75th=temp_all2[(int)Math.floor((temp_count-1)/4)]+
				((temp_count-1)/4-Math.floor((temp_count-1)/4))*(temp_all2[(int)Math.ceil((temp_count-1)/4)]-temp_all2[(int)Math.floor((temp_count-1)/4)]);
			temp_25th=temp_all2[(int)Math.floor((temp_count-1)*3/4)]+
				((temp_count-1)*3/4-Math.floor((temp_count-1)*3/4))*(temp_all2[(int)Math.ceil((temp_count-1)*3/4)]-temp_all2[(int)Math.floor((temp_count-1)*3/4)]);
			if(temp_all2.length/2==Math.floor(temp_all2.length/2)){temp_med=temp_all2[(int)Math.floor(temp_all2.length/2)];}
			else{temp_med=(temp_all2[temp_all2.length/2-1]+temp_all2[temp_all2.length/2])/2;}
		}
		else{temp_ave=-1;temp_med=-1;temp_max=-1;temp_min=-1;temp_std=0;temp_25th=-1;temp_75th=-1;}
		TA_out.setText("                   DESCRIPTIVE STATISTICS                   \n");
		TA_out.append( "  ----------------------------------------------------------\n");
		
		if((int)temp_min==-1){temp1="na";}
		else{temp1=Double.toString(round(temp_min,3));}
		if(temp1.length()==12){temp1=temp1+" ";}
		else if(temp1.length()==11){temp1=temp1+"  ";}
		else if(temp1.length()==10){temp1=temp1+"   ";}
		else if(temp1.length()==9){temp1=temp1+"    ";}
		else if(temp1.length()==8){temp1=temp1+"     ";}
		else if(temp1.length()==7){temp1=temp1+"      ";}
		else if(temp1.length()==6){temp1=temp1+"       ";}
		else if(temp1.length()==5){temp1=temp1+"        ";}
		else if(temp1.length()==4){temp1=temp1+"         ";}
		else if(temp1.length()==3){temp1=temp1+"          ";}
		else if(temp1.length()==2){temp1=temp1+"           ";}
		else if(temp1.length()==1){temp1=temp1+"            ";}
		TA_out.append("        Min    = "+temp1);
		
		if((int)temp_count==-1){temp1="na";}
		else{temp1=Integer.toString((int)temp_count);}
		if(temp1.length()==12){temp1=temp1;}
		TA_out.append("  N     = "+temp1+"\n");
		
		if((int)temp_25th==-1){temp1="na";}
		else{temp1=Double.toString(round(temp_25th,3));}
		if(temp1.length()==12){temp1=temp1+" ";}
		else if(temp1.length()==11){temp1=temp1+"  ";}
		else if(temp1.length()==10){temp1=temp1+"   ";}
		else if(temp1.length()==9){temp1=temp1+"    ";}
		else if(temp1.length()==8){temp1=temp1+"     ";}
		else if(temp1.length()==7){temp1=temp1+"      ";}
		else if(temp1.length()==6){temp1=temp1+"       ";}
		else if(temp1.length()==5){temp1=temp1+"        ";}
		else if(temp1.length()==4){temp1=temp1+"         ";}
		else if(temp1.length()==3){temp1=temp1+"          ";}
		else if(temp1.length()==2){temp1=temp1+"           ";}
		else if(temp1.length()==1){temp1=temp1+"            ";}
		TA_out.append("        Q1     = "+temp1);
		
		if((int)temp_ave==-1){temp1="na";}
		else{temp1=Double.toString(round(temp_ave,3));}
		TA_out.append("  Mean  = "+temp1+"\n");
		
		if((int)temp_med==-1){temp1="na";}
		else{temp1=Double.toString(round(temp_med,3));}
		if(temp1.length()==12){temp1=temp1+" ";}
		else if(temp1.length()==11){temp1=temp1+"  ";}
		else if(temp1.length()==10){temp1=temp1+"   ";}
		else if(temp1.length()==9){temp1=temp1+"    ";}
		else if(temp1.length()==8){temp1=temp1+"     ";}
		else if(temp1.length()==7){temp1=temp1+"      ";}
		else if(temp1.length()==6){temp1=temp1+"       ";}
		else if(temp1.length()==5){temp1=temp1+"        ";}
		else if(temp1.length()==4){temp1=temp1+"         ";}
		else if(temp1.length()==3){temp1=temp1+"          ";}
		else if(temp1.length()==2){temp1=temp1+"           ";}
		else if(temp1.length()==1){temp1=temp1+"            ";}
		TA_out.append("        Median = "+temp1);
	
		if(temp_std>0){temp1=Double.toString(round(temp_std,3));}
		else{temp1="na";}
		TA_out.append("  StDev = "+temp1+"\n");
	
		if((int)temp_75th==-1){temp1="na";}
		else{temp1=Double.toString(round(temp_75th,3));}
		if(temp1.length()==12){temp1=temp1+" ";}
		else if(temp1.length()==11){temp1=temp1+"  ";}
		else if(temp1.length()==10){temp1=temp1+"   ";}
		else if(temp1.length()==9){temp1=temp1+"    ";}
		else if(temp1.length()==8){temp1=temp1+"     ";}
		else if(temp1.length()==7){temp1=temp1+"      ";}
		else if(temp1.length()==6){temp1=temp1+"       ";}
		else if(temp1.length()==5){temp1=temp1+"        ";}
		else if(temp1.length()==4){temp1=temp1+"         ";}
		else if(temp1.length()==3){temp1=temp1+"          ";}
		else if(temp1.length()==2){temp1=temp1+"           ";}
		else if(temp1.length()==1){temp1=temp1+"            ";}
		TA_out.append("        Q3     = "+temp1);
		
		if(temp_std>0){temp1=Double.toString(round(temp_75th-temp_25th,3));}
		else{temp1="na";}
		TA_out.append("  IQR   = "+temp1+"\n");

		if((int)temp_max==-1){temp1="na";}
		else{temp1=temp1=Double.toString(round(temp_max,3));}
		if(temp1.length()==12){temp1=temp1+" ";}
		else if(temp1.length()==11){temp1=temp1+"  ";}
		else if(temp1.length()==10){temp1=temp1+"   ";}
		else if(temp1.length()==9){temp1=temp1+"    ";}
		else if(temp1.length()==8){temp1=temp1+"     ";}
		else if(temp1.length()==7){temp1=temp1+"      ";}
		else if(temp1.length()==6){temp1=temp1+"       ";}
		else if(temp1.length()==5){temp1=temp1+"        ";}
		else if(temp1.length()==4){temp1=temp1+"         ";}
		else if(temp1.length()==3){temp1=temp1+"          ";}
		else if(temp1.length()==2){temp1=temp1+"           ";}
		else if(temp1.length()==1){temp1=temp1+"            ";}
		TA_out.append("        Max    = "+temp1+"\n\n");
		
		

		// PRINT OUT PERCENT ERROR AND CI INFORMATION	
		TA_out.append("     SI     %Error          LB           EST            UB\n");
		TA_out.append( "  ----------------------------------------------------------\n");
		for(int i=0;i<n_si;i++){
			temp1=Integer.toString((int)round(xxx[i],0));
			if(temp1.length()==4){temp1=" "+temp1;}
			else if(temp1.length()==3){temp1="  "+temp1;}
			else if(temp1.length()==2){temp1="   "+temp1;}
			else if(temp1.length()==1){temp1="    "+temp1;}
			TA_out.append("  "+temp1+"  ");
			
			dot=0;
			if(covs[tattr-1][i]==-1){TA_out.append("       na");}
			else{
				temp1=Double.toString(round(covs[tattr-1][i]*100,5));
				for(int j=0;j<temp1.length();j++){if(temp1.charAt(j)=='.'){dot=j+2;}}
				temp1=temp1.substring(0,dot+1);
								
				if(temp1.length()==8){temp1=" "+temp1;}
				else if(temp1.length()==7){temp1="  "+temp1;}
				else if(temp1.length()==6){temp1="   "+temp1;}
				else if(temp1.length()==5){temp1="    "+temp1;}
				else if(temp1.length()==4){temp1="     "+temp1;}
				else if(temp1.length()==3){temp1="      "+temp1;}
				else if(temp1.length()==2){temp1="       "+temp1;}
				else if(temp1.length()==1){temp1="        "+temp1;}
				TA_out.append(temp1);
			}
			
			for(int j=2;j>=0;j--){
				if(ci[tattr-1][i][j]==-1){temp1="          na";}
				else{
					dot=0;
					temp1=Double.toString(round(ci[tattr-1][i][j],5));
					for(int k=0;k<temp1.length();k++){if(temp1.charAt(k)=='.'){dot=k+1;}}
					if(dot+3<temp1.length()){temp1=temp1.substring(0,dot+3);}

					if(temp1.indexOf('.')==-1){temp1=temp1+".000";}
					else if(temp1.length()-temp1.indexOf('.')==3){temp1=temp1+"0";}
					else if(temp1.length()-temp1.indexOf('.')==2){temp1=temp1+"00";}
					else if(temp1.length()-temp1.indexOf('.')==1){temp1=temp1+"000";}
					
					if(temp1.length()==11){temp1=" "+temp1;}
					else if(temp1.length()==10){temp1="  "+temp1;}
					else if(temp1.length()==9){temp1="   "+temp1;}
					else if(temp1.length()==8){temp1="    "+temp1;}
					else if(temp1.length()==7){temp1="     "+temp1;}
					else if(temp1.length()==6){temp1="      "+temp1;}
					else if(temp1.length()==5){temp1="       "+temp1;}
					else if(temp1.length()==4){temp1="        "+temp1;}
					else if(temp1.length()==3){temp1="         "+temp1;}
					else if(temp1.length()==2){temp1="          "+temp1;}
					else if(temp1.length()==1){temp1="           "+temp1;}
				}
				if(j==0){TA_out.append(temp1+"\n");}
				else{TA_out.append(temp1+"  ");}
			}
		}		
		TA_out.setSelectionStart(0);
		TA_out.setSelectionEnd(0);
	}
	
	public double round(double num,int places){
		double temp = num;
		int temp2;
		temp=temp*Math.pow(10,(double)places);
		if(num-Math.floor(num)>=0.5){temp=Math.ceil(temp);}
		else{temp=Math.floor(temp);}
		temp2=(int)temp;
		temp=((double)temp2)*Math.pow(10,-1*(double)places);
		return(temp);
	}
		
	
	
	public void changegraph(){
		this.remove(g1);
		g1.removeAll();
		validate();
		g1 = new Graph(Integer.MAX_VALUE,Integer.MAX_VALUE,Integer.MAX_VALUE,(int)Math.floor(ymin),(int)Math.ceil(ymax),Integer.MAX_VALUE);
		c.gridx=5; c.gridy=2; c.gridwidth=8; c.gridheight=9;
		c.weightx = 0; c.weighty = 0;
		this.add(g1,c);
		
		
		this.remove(g2);
		g2.removeAll();
		validate();
		g2 = new Graph(Integer.MAX_VALUE,Integer.MAX_VALUE,Integer.MAX_VALUE,(int)Math.floor(ci_min),(int)Math.ceil(ci_max),Integer.MAX_VALUE);
		c.gridx=14; c.gridy=2; c.gridwidth=10; c.gridheight=9;
		c.weightx = 0; c.weighty = 0;
		this.add(g2,c);
	}
	
	/****************************************************************************************/
	/* PLACE GRAPHS -- PLACES THE PLOTS SELECTED IN CHECKBOXES                              */
	/****************************************************************************************/
	
	public void placegraphs(){
		g1.removeAll();g2.removeAll();
		if(CB_exact.getState()){g1.addPlot(p3);g2.addPlot(p5);g2.addPlot(p6);g2.addPlot(p7);}
		if(CB_smooth.getState()){g1.addPlot(p1);g2.addPlot(p8);g2.addPlot(p9);g2.addPlot(p10);}
		if(CB_asymp.getState()){g1.addPlot(p4);}
		if(CB_crit.getState()){g1.addPlot(p2);}
		g1.repaint();g2.repaint();validate();
	}
	
	/****************************************************************************************/
	/* PLOT NOTHING -- MAKES BOTH OF THE PLOTS AND THE OUTPUT FIELDS BLANK                  */
	/****************************************************************************************/
	public void plotnothing(){
		ymin=0;
		ymax=100;
		dp1 = new DoublePoint[2];dp1[0] = new DoublePoint(0,0);dp1[1] = new DoublePoint(0,0);p1 = new Plot(dp1,Color.blue);
		dp2 = new DoublePoint[2];dp2[0] = new DoublePoint(0,0);dp2[1] = new DoublePoint(0,0);p2 = new Plot(dp2,Color.red);
		dp3 = new DoublePoint[2];dp3[0] = new DoublePoint(0,0);dp3[1] = new DoublePoint(0,0);p3 = new Plot(dp3,Color.black);
		dp4 = new DoublePoint[2];dp4[0] = new DoublePoint(0,0);dp4[1] = new DoublePoint(0,0);p4 = new Plot(dp4,Color.green);
		dp5 = new DoublePoint[2];dp5[0] = new DoublePoint(0,0);dp5[1] = new DoublePoint(0,0);p5 = new Plot(dp5,Color.black);
		dp6 = new DoublePoint[2];dp6[0] = new DoublePoint(0,0);dp6[1] = new DoublePoint(0,0);p6 = new Plot(dp6,Color.black);
		dp7 = new DoublePoint[2];dp7[0] = new DoublePoint(0,0);dp7[1] = new DoublePoint(0,0);p7 = new Plot(dp7,Color.black);
		dp8 = new DoublePoint[2];dp8[0] = new DoublePoint(0,0);dp8[1] = new DoublePoint(0,0);p8 = new Plot(dp8,Color.blue);
		dp9 = new DoublePoint[2];dp9[0] = new DoublePoint(0,0);dp9[1] = new DoublePoint(0,0);p9 = new Plot(dp9,Color.blue);
		dp10 = new DoublePoint[2];dp10[0] = new DoublePoint(0,0);dp10[1] = new DoublePoint(0,0);p10 = new Plot(dp10,Color.blue);
		changegraph();
		placegraphs();
		L_labels[13].setText("");L_labels[14].setText("");
		L_labels[15].setText("");L_labels[16].setText("");
		TA_out.setText("");TA_nnn.setText("");TF_nnn.setText("");TF_nn2.setText("");
	}
	
	/****************************************************************************************/
	/* PLOT GRAPHS                                                                          */
	/****************************************************************************************/
	
	public void plotgraph(){
		ci_min=10000000;
		ci_max=0;
		int count1=0;
		double est=-1;
		
		for(int i=0;i<n_si;i++){
			if(ci_min>ci[tattr-1][i][2] && ci[tattr-1][i][2]!=-1){ci_min=ci[tattr-1][i][2];}
			if(ci_max<ci[tattr-1][i][0] && ci[tattr-1][i][0]!=-1){ci_max=ci[tattr-1][i][0];}
			if(ci[tattr-1][i][0]!=-1 && ci[tattr-1][i][2]!=-1){count1++;}
		}
		if(count1>=2 && NNN>1){
			dp5 = new DoublePoint[count1];
			dp6 = new DoublePoint[count1];
			dp7 = new DoublePoint[count1];
			double[][] smooth1 = new double[count1][2];
			double[][] smooth2 = new double[count1][2];
			double[][] smooth3 = new double[count1][2];
			count1=0;
			for(int i=0;i<n_si;i++){
				if(ci[tattr-1][i][0]!=-1 && ci[tattr-1][i][2]!=-1){
					smooth1[count1][0]=xxx[i];
					smooth1[count1][1]=ci[tattr-1][i][0];
					smooth2[count1][0]=xxx[i];
					smooth2[count1][1]=ci[tattr-1][i][1];
					smooth3[count1][0]=xxx[i];
					smooth3[count1][1]=ci[tattr-1][i][2];		
					dp5[count1] = new DoublePoint(xxx[i],ci[tattr-1][i][0]);
					dp6[count1] = new DoublePoint(xxx[i],ci[tattr-1][i][1]);
					dp7[count1] = new DoublePoint(xxx[i],ci[tattr-1][i][2]);
					count1++;
				}
			}
			if(n_si>1){
				smooth1 = getfits4.manipdata(smooth1,4,1,false);
				smooth2 = getfits4.manipdata(smooth2,4,1,false);
				smooth3 = getfits4.manipdata(smooth3,4,1,false);
			}
			dp8 = new DoublePoint[smooth1.length];
			dp9 = new DoublePoint[smooth1.length];
			dp10 = new DoublePoint[smooth1.length];
			for(int i=0;i<smooth1.length;i++){
				dp8[i]=new DoublePoint(smooth1[i][0],smooth1[i][1]);
				dp9[i]=new DoublePoint(smooth2[i][0],smooth2[i][1]);
				dp10[i]=new DoublePoint(smooth3[i][0],smooth3[i][1]);
			}
		}		
		else{
			dp5 = new DoublePoint[2];dp5[0] = new DoublePoint(0,0);dp5[1] = new DoublePoint(0,0);
			dp6 = new DoublePoint[2];dp6[0] = new DoublePoint(0,0);dp6[1] = new DoublePoint(0,0);
			dp7 = new DoublePoint[2];dp7[0] = new DoublePoint(0,0);dp7[1] = new DoublePoint(0,0);
			dp8 = new DoublePoint[2];dp8[0] = new DoublePoint(0,0);dp8[1] = new DoublePoint(0,0);
			dp9 = new DoublePoint[2];dp9[0] = new DoublePoint(0,0);dp9[1] = new DoublePoint(0,0);
			dp10 = new DoublePoint[2];dp10[0] = new DoublePoint(0,0);dp10[1] = new DoublePoint(0,0);
		}
		
			
		p5 = new Plot(dp5,Color.black);
		p6 = new Plot(dp6,Color.black);
		p7 = new Plot(dp7,Color.black);
		p8 = new Plot(dp8,Color.blue);
		p9 = new Plot(dp9,Color.blue);
		p10 = new Plot(dp10,Color.blue);

		ymin=0;
		int count=0;
		int count2=0;
		for(int i=0;i<n_si;i++){
			if(covs[tattr-1][i]>.0001){count++;}
		}
		
		if(count<2){
			dp1 = new DoublePoint[2];dp1[0] = new DoublePoint(min_si,0);dp1[1] = new DoublePoint(min_si,0);
			dp2 = new DoublePoint[2];dp2[0] = new DoublePoint(min_si,ycrit);dp2[1] = new DoublePoint(max_si,ycrit);
			dp3 = new DoublePoint[2];dp3[0] = new DoublePoint(min_si,0);dp3[1] = new DoublePoint(min_si,0);
			dp4 = new DoublePoint[2];dp4[0] = new DoublePoint(min_si,0);dp4[1] = new DoublePoint(min_si,0);
			ymax=100;
		}
		else{
			ymin=ycrit;
			double[][] temp = new double[count][2];
			count2=count;
			count=0;
			int index=0;
			while(count<count2){
				if(covs[tattr-1][index]>0){
					temp[count][0]=xxx[index];
					temp[count][1]=100*covs[tattr-1][index];
					if(ymin>temp[count][1]){ymin=temp[count][1];}
					count++;
				}
				index++;
			}
			double[][] plotdata;
			if(n_si>1){plotdata = getfits4.manipdata(temp,2,1,true);}
			else{
				plotdata = new double[temp.length][2];
				for(int i=0;i<temp.length;i++){plotdata[i][0]=temp[i][0];plotdata[i][1]=temp[i][1];}
			}
			dp1 = new DoublePoint[plotdata.length];
			dp2 = new DoublePoint[2];dp2[0] = new DoublePoint(min_si,ycrit);dp2[1] = new DoublePoint(max_si,ycrit);
			dp3 = new DoublePoint[temp.length];
			dp4 = new DoublePoint[n_si];
			// smoothed exact curve
			for(int i=0;i<plotdata.length;i++){
				dp1[i] = new DoublePoint(plotdata[i][0],plotdata[i][1]);
				if(ymin>plotdata[i][1]){ymin=plotdata[i][1];}
			}
			// unsmoothed exact curve
			for(int j=0;j<temp.length;j++){dp3[j]=new DoublePoint(temp[j][0],temp[j][1]);}
			// asymptotic curve
			double CCC = temp[temp.length-1][1]*Math.sqrt(temp[temp.length-1][0]);
			for(int j=0;j<n_si;j++){dp4[j]=new DoublePoint(xxx[j],CCC/Math.sqrt(xxx[j]));}
			ymin=Math.floor(ymin);
			while(ymin/5!=Math.floor(ymin/5)){ymin=ymin-1;}
			ymax=ycrit+1;
			if(ymax<plotdata[0][1]){ymax=plotdata[0][1];}
			if(ymax<temp[0][1]){ymax=temp[0][1];}
			if(ymax<CCC/Math.sqrt(xxx[0])){ymax=CCC/Math.sqrt(xxx[0]);}
		}
		changegraph();
		p1 = new Plot(dp1,Color.blue);
		p2 = new Plot(dp2,Color.red);
		p3 = new Plot(dp3,Color.black);
		p4 = new Plot(dp4,Color.green);		
		placegraphs();
		String sss_name = C_strat.getSelectedItem();
		String aaa_name = C_attr.getSelectedItem();
		if(sss_name.length()>15){sss_name=sss_name.substring(0,15);}
		if(aaa_name.length()>15){aaa_name=aaa_name.substring(0,15);}

		L_labels[13].setText("% Error of the estimate of mean "+aaa_name);
		L_labels[14].setText("in stratum "+sss_name+" vs sampling intensity");
		L_labels[15].setText(((int)((1-alpha)*100))+"% Confidence Interval for the estimate of mean");
		L_labels[16].setText(aaa_name+" in stratum "+sss_name+" vs sampling intensity");

		
	}
	
	
	/****************************************************************************************/
	/* FILL IN ALL THE SAMPLE SIZE TEXT FIELDS                                              */
	/****************************************************************************************/
	
	public void print_allsizes(){
		int min=0;
		boolean isna=false;
		int count1 = 0;
		double[][] data;
		if(newdata || doboot || newsize){
			for(int i=0;i<nattr;i++){
				nn[i]=-1;
				count1=0;
				for(int j=0;j<n_si;j++){if(covs[i][j]>0){count1++;}}
				if(count1<2){nn[i]=-1;}
				else{
					data = new double[count1][2];
					count1=0;
					for(int j=0;j<n_si;j++){
						if(covs[i][j]>0){
							data[count1][0]=xxx[j];
							data[count1][1]=covs[i][j];
							count1++;
						}
					}
					double[][] data2 = getfits4.manipdata(data,2,step_si,true);
					
					if(data2[0][1]*100<ycrit){nn[i]=(int)Math.ceil(data2[0][0]);}
					else{
						for(int j=1;j<data2.length;j++){
							if(data2[j][1]*100<ycrit && data2[j-1][1]*100>ycrit){
								nn[i]=(int)Math.ceil(data2[j][0]);
							}
						}
					}
				}
			}
			TA_nnn.setText("");
			for(int i=0;i<nattr;i++){
				if(nn[i]!=-1 && i<nattr-1){TA_nnn.append(Integer.toString(nn[i])+",");}
				else if(nn[i]==-1 && i<nattr-1){TA_nnn.append("na,");}
				else if(nn[i]!=-1){TA_nnn.append(Integer.toString(nn[i]));}
				else{TA_nnn.append("na");}
			}
			TA_nnn.setSelectionStart(0);TA_nnn.setSelectionEnd(0);
			for(int i=0;i<nattr;i++){
				if(nn[i]==-1){isna=true;}
				else if(nn[i]>min){min=nn[i];}
			}
			if(isna){TF_nnn.setText("na");}
			else{TF_nnn.setText(Integer.toString(min));}
		}
		if(nn[tattr-1]==-1){TF_nn2.setText("na");}
		else{TF_nn2.setText(Integer.toString(nn[tattr-1]));}
	}
		
	
	
	/****************************************************************************************/
	/* The real number crunching starts here                                                */
	/****************************************************************************************/
	

	public void boot(double[][] psu_data) {
		ci = new double[nattr][n_si][3];

		double[] means = new double[nattr];
		double[][] all_means = new double[nattr][nsim];
		
		int x=min_si;
		int index=0;
		while(x<=max_si){
			for(int i=0;i<nsim;i++){
				means=ave(x,psu_data);
				for(int j=0;j<nattr;j++){
					all_means[j][i]=means[j];
				}
			}
			make_ci(all_means,index);
			update_covs(index,all_means);
			xxx[index]=(double)x;
			if(step_si==0){x=x+1;}
			else{x=x+step_si;}
			index++;
		}
	}
	
	public void make_ci(double[][] all_means,int index){
		double[] temp = new double[nsim];
		double[] temp2;
		int lb=0;
		int ub=temp.length-1;
		for(int i=0;i<nattr;i++){
			for(int j=0;j<nsim;j++){temp[j]=all_means[i][j];}
			temp2=slowsort(temp);
			if(temp2.length==0){
				ci[i][index][0]=-1;
				ci[i][index][1]=-1;
				ci[i][index][2]=-1;
			}
			else{
				if((int)Math.floor((double)temp2.length*alpha/2)-1>=0){lb=(int)Math.floor((double)temp2.length*alpha/2)-1;}
				else{lb=0;}
				if((int)Math.ceil((double)temp2.length*(1-alpha/2))-1<=temp2.length-1){ub=(int)Math.ceil((double)temp2.length*(1-alpha/2))-1;}
				else{ub=temp2.length-1;}
				ci[i][index][0]=temp2[lb];ci[i][index][1]=average(temp2);ci[i][index][2]=temp2[ub];
			}
		}
	}
	
	public static double average(double[] ppp){
		double sum=0;
		double count=0;
		for(int i=0;i<ppp.length;i++){
			if(ppp[i]!=-1){
				sum=sum+ppp[i];
				count++;
			}
		}
		if(count==0){return(-1);}
		else{return(sum/count);}
	}
	
	public static double[] slowsort(double[] ppp){
		double temp;
		int count=0;
		for(int i=0;i<ppp.length;i++){
			for(int j=i+1;j<ppp.length;j++){
				if(ppp[i]<ppp[j]){
					temp=ppp[i];
					ppp[i]=ppp[j];
					ppp[j]=temp;
				}
			}
		}
		for(int i=0;i<ppp.length;i++){if(ppp[i]>=0){count++;}}
		double[] output = new double[count];
		count=0;
		for(int i=0;i<ppp.length;i++){
			if(ppp[i]>=0){output[count]=ppp[i];count++;}
		}
		return(output);
	}
	
	public void update_covs(int col,double[][] all_means){
		double[] means = new double[nattr];
		double[] counts = new double[nattr];
		double[] vars = new double[nattr];
		
		for(int i=0;i<nattr;i++){
			for(int j=0;j<nsim;j++){
				if(all_means[i][j]!=-1){
					means[i]=means[i]+all_means[i][j];
					counts[i]++;
				}
			}
			if(counts[i]>0){means[i]=means[i]/counts[i];}
			else{means[i]=-1;}
		}
		for(int i=0;i<nattr;i++){
			if(counts[i]>1){
				for(int j=0;j<nsim;j++){
					if(all_means[i][j]!=-1){
						vars[i]=vars[i]+Math.pow(means[i]-all_means[i][j],2)/(counts[i]-1);
					}
				}
			}
			else{vars[i]=-1;}
			if(vars[i]!=-1 && means[i]>0){covs[i][col]=Math.sqrt(vars[i])/means[i];}
			else{covs[i][col]=-1;}
		}
	}
					
	public double[] ave(int x,double[][] data){
		int rpsu;
		int rsub;
		double[] means = new double[nattr];
		double[] count = new double[nattr];
		
		for(int i=0;i<nattr;i++){count[i]=0;means[i]=0;}
		for(int i=0;i<x;i++){
			rpsu=(int)Math.floor(Math.random()*npsu+1);
			for(int j=0;j<nsub;j++){
				rsub=(int)Math.floor(Math.random()*nsub+1);
				if((int)tstrata==data[rpsu*nsub-rsub][1]){
					for(int k=0;k<nattr;k++){
						if(data[rpsu*nsub-rsub][k+2]!=-1){
							means[k]=means[k]+data[rpsu*nsub-rsub][k+2];
							count[k]++;
						}
					}
				}
			}
		}
		for(int i=0;i<nattr;i++){
			if(count[i]>0){means[i]=means[i]/count[i];}
			else{means[i]=-1;}
		}
		return(means);
	}
	
	/****************************************************************************************/
	/* ORDER INPUT DATA BY PSU                                                              */
	/****************************************************************************************/
	public double[][] order_psu(double[][] data){
		int row_size=nattr+2;
		int index=0;
		double tpsu;
		double temp_val;
		double[][] out_data = new double[100000][row_size];
		for(int i=0;i<data.length;i++){
			for(int j=i+1;j<data.length;j++){
				if(data[i][0]>data[j][0]){
					for(int k=0;k<row_size;k++){
						temp_val=data[i][k];
						data[i][k]=data[j][k];
						data[j][k]=temp_val;
					}
				}						
			}
		}
		
		int tempmax=1;
		int tempthis=1;
		int index1=1;
		while(index1<data.length && tempmax<=nsub){
			if(data[index1][0]==data[index1-1][0]){
				tempthis++;
			}
			else{
				if(tempmax<tempthis){tempmax=tempthis;}
				tempthis=1;
			}
			index1++;
		}
		
		double[][] output;
		if(tempmax<=nsub){	
			index1=1;	
			int index2=1;
			int tset=1;
			for(int j=0;j<row_size;j++){
				out_data[0][j]=data[0][j];
			}	
			while(index2<data.length){
				if(tset<4 && data[index2][0]==out_data[index1-1][0]){
					for(int j=0;j<row_size;j++){
						out_data[index1][j]=data[index2][j];
					}
					tset++;
					index2++;
				}
				else if(tset<4 && data[index2][0]!=out_data[index1-1][0]){
					out_data[index1][0]=out_data[index1-1][0];
					for(int j=1;j<row_size;j++){out_data[index1][j]=-1;}
					tset++;
				}
				else{
					for(int j=0;j<row_size;j++){out_data[index1][j]=data[index2][j];}
					tset=1;
					index2++;
				}
				index1++;
			}
			
			nrows=index1;
			output= new double[index1][row_size];
			for(int i=0;i<output.length;i++){
				for(int j=0;j<row_size;j++){
					output[i][j]=out_data[i][j];
				}
			}
		}
		else{
			output = new double[2][2];
		}			
		return(output);
	}
	
	
	/****************************************************************************************/
	/* This method reads in the data and then creats stratum and attribute pull down menus. */
	/****************************************************************************************/
	
	public double[][] getdata(){
		goodtogo=false;
		int temp1=1;
		int temp2=1;
		double[][] temp = new double[1][1];
		if(read_parms1()){
			if(errorcheck_1() && !TA_in.getText().trim().equals("")){
				temp = read3(TA_in.getText().trim());
				if(errorcheck_2()){
					goodtogo=true;
					temp=order_psu(temp);
					
					if(temp.length>2){
						npsu=temp.length/nsub;
					}
					else{
						goodtogo=false;
						TF_inputs[3].setText("???");
					}
				}
				else{goodtogo=false;plotnothing();}
				C_strat.removeAll();
				C_attr.removeAll();
				if(goodtogo){
					for(int i=0;i<strat_key.length;i++){
						if(strat_key[i][1].equals("")){C_strat.add(" ");}
						else{C_strat.add(strat_key[i][1]);}
					}				
					for(int i=0;i<nattr;i++){
						if(attr_key[i].equals("")){C_attr.add("attribute_"+Integer.toString(i+1));}
						else{C_attr.add(attr_key[i]);}
					}
				}
			}
			else if(TA_in.getText().trim().equals("")){TA_in.setText("Where's the data?");}
		}
		return(temp);	
	}

	public int find_attr(){
		int output=0;
		String new_attr=C_attr.getSelectedItem();
		boolean keepgoing=true;
		int index=0;
		while(keepgoing && index<nattr){
			if(attr_key[index].equals(new_attr.trim())){keepgoing=false;}
			index++;
		}
		return(index);
	}
	
	
	public int find_strat(){
		boolean keepgoing=true;
		int output=0;
		String new_strat = C_strat.getSelectedItem();
		int index=0;
		while(keepgoing && index<strat_key.length){
			if(strat_key[index][1].equals(new_strat.trim())){
				keepgoing=false;
				output=(int)Double.valueOf(strat_key[index][0]).doubleValue();
			}
			index++;
		}
		return(output);
	}
		
	public void make_strat_key(String[] strat_key2,int index3){
		String temp;
		int index=0;
		String[][] strat_key3 = new String[index3][2];
		
		for(int i=0;i<index3;i++){
			for(int j=i;j<index3;j++){
				if(0<strat_key2[i].compareTo(strat_key2[j])){
					temp=strat_key2[i];
					strat_key2[i]=strat_key2[j];
					strat_key2[j]=temp;
				}
			}
		}
		strat_key3[0][0]="1";
		strat_key3[0][1]=strat_key2[0];
		
		for(int i=1;i<index3;i++){
			if(!strat_key2[i].equals(strat_key2[i-1])){
				index++;
				strat_key3[index][0]=Integer.toString(index+1);
				strat_key3[index][1]=strat_key2[i];
			}
		}
		nstrata=index+1;
		strat_key = new String[nstrata][2];
		for(int i=0;i<nstrata;i++){
			strat_key[i][0]=strat_key3[i][0];
			strat_key[i][1]=strat_key3[i][1];
		}
		if(strat_key[0][1].equals("")){
			for(int i=0;i<nstrata-1;i++){
				strat_key[i][1]=strat_key[i+1][1];
			}
			strat_key[nstrata-1][1]="";
		}
	}

	/****************************************************************************************/
	/* This method reads the data from the input text field and transforms it into an array */
	/* of doubles where missing values are coded as -1.                                     */
	/****************************************************************************************/
	
	public double[][] read3(String file_string){
		int comma1;
		int comma2;
		int place2;
		int last=0;
		int col=0;
		int row=0;
		
		int index1=0,index2=0,index3=0;							
		String sub1, sub2;			
		String[] strat_key2 = new String[100000];
		
		for(int k=0;k<strat_key2.length;k++){strat_key2[k]="";}
		for(int k=0;k<attr_key.length;k++){attr_key[k]="";}
		int nrow=100000;
		int ncol=102;
		int numcols=0;
		double[][] output = new double[nrow][ncol];
		for(int i=0;i<nrow;i++){
			for(int j=0;j<ncol;j++){
				output[i][j]=-1;
			}
		}
		// CREATE ATTRIBUTE KEY

		/*****************************************************************************************/
		// IF WE HAVE AN ATTRIBUTE KEY
		if(CB_header.getState()){
			sub1=file_string.substring(0,file_string.indexOf('\n')).trim();
			file_string=file_string.substring(file_string.indexOf('\n')+1,file_string.length());
			while(sub1.length()>0){
				index2=sub1.indexOf(',');
				if(index2==-1){
					sub2=sub1;
					sub1="";
				}
				else{
					sub2=sub1.substring(0,index2);
					if(sub2.equals("")){sub2="attribute_"+Integer.toString(index1-2);}
					sub1=sub1.trim().substring(index2+1,sub1.length());
				}
				if(index1>1){
					attr_key[index1-2]=sub2;
					
				}
				index1++;
			}
			nattr=index1-2;
		}
		index1=0;
		index2=0;
		sub1="";
		sub2="";
		
		/*****************************************************************************************/
		// MAKE STRATUM KEY
		while(index1<file_string.length()){
			sub1=file_string.substring(index1,index1+1);
			if(sub1.equals(",")){
				sub2=file_string.substring(last,index1);
				if(col==1){
					strat_key2[index2]=sub2;
					index2++;
				}
				last=index1+1;
				col++;
			}
			else if(index1<(file_string.length()-2) && sub1.equals("\n") && 
				file_string.substring(index1+1,index1+2).equals("\n")){index1=file_string.length();row++;}
			else if(sub1.equals("\n")){
				sub2=file_string.substring(last,index1);
				if(col==1){
					strat_key2[index2]=sub2;
					index2++;
				}
				last=index1+1;
				col=0;
				row++;
			}
			if(numcols<col){numcols=col;}
			index1++;
		}
		make_strat_key(strat_key2,index2);
		
		index1=0;
		index2=0;
		sub1="";
		sub2="";	
		last=0;
		row=0;
		col=0;
		
		/*****************************************************************************************/
		// READ IN DATA
		while(index1<file_string.length()){
			sub1=file_string.substring(index1,index1+1);
			if(sub1.equals(",")){
				sub2=file_string.substring(last,index1);
				if(col==1){
					for(int i=0;i<nstrata;i++){
						if(sub2.equals(strat_key[i][1])){
							output[row][col]=Double.valueOf(strat_key[i][0]).doubleValue();
						}
					}
				}
				else if(sub2.length()==0){output[row][col]=-1;}
				else{
					try{
						output[row][col]=Double.valueOf(sub2.trim()).doubleValue();
					}catch(NumberFormatException nfe){output[row][col]=-1;}
				}
				last=index1+1;
				col++;
			}
			else if(index1<(file_string.length()-2) && sub1.equals("\n") && 
				file_string.substring(index1+1,index1+2).equals("\n")){index1=file_string.length();row++;}
			else if(sub1.equals("\n")){
				sub2=file_string.substring(last,index1);
				if(col==1){
					for(int i=0;i<nstrata;i++){
						if(sub2.equals(strat_key[i][1])){
							output[row][col]=Double.valueOf(strat_key[i][0]).doubleValue();
						}
					}
				}
				else if(sub2.length()==0){output[row][col]=-1;}
				else{
					try{
						output[row][col]=Double.valueOf(sub2.trim()).doubleValue();
					}catch(NumberFormatException nfe){output[row][col]=-1;}					
				}
				last=index1+1;
				col=0;
				row++;
			}
			if(numcols<col){numcols=col;}
			index1++;
		}
		
		
		numcols++;
		row++;
		
		if(nattr<numcols-2){nattr=numcols;}	
		double[][] output2 = new double[row][numcols];
		for(int k=0;k<row;k++){
			for(int m=0;m<numcols;m++){
				output2[k][m]=output[k][m];
			}
		}
		if(!CB_header.getState()){
			nattr=numcols-2;
			for(int i=0;i<nattr;i++){
				attr_key[i]="attribute_"+Integer.toString(i+1);
			}
		}
		return(output2);	
	}
}
