import java.lang.Math;
import java.awt.*;

public class getfits4 {
	
	public static double[][] manipdata(double[][] allinput,int P,int resfac,boolean mono) {
		
		double[][] V1 = new double[allinput.length][2];
		
		double[][] output;
		

		for (int i=0;i<allinput.length;i++){
			V1[i][0]=allinput[i][0];				
			V1[i][1]=allinput[i][1];
		}
		double[][] V1b;
		if(mono){
			V1b = monotonic(smooth(V1,resfac,P));
			V1b = monotonic(smooth(V1b,1,P));
		}
		else{
			V1b = smooth(V1,resfac,P);
		}
			
		output = new double[V1b.length][2];
		for (int i=0;i<output.length;i++){
			output[i][0]=V1b[i][0];
			output[i][1]=V1b[i][1];
		}

		return output;
	}
	
	public static double[][] smooth(double[][] data, int resfac, int P){
		int res = resfac*(data.length-1);
		int G;
		int L=0;
		int S;
		int E;
		int index1;
		
		double[] coefs = new double[2];
		double[][] output = new double[res+1][2];
		double step = (data[data.length-1][0]-data[0][0])/(double)res;
		output[0][0]=data[0][0];
		for(int i=1;i<output.length;i++){
			output[i][0]=output[i-1][0]+step;
			output[i][1]=0;
		}
		for (int i=0; i<output.length; i++){
			if(output[i][0]>=data[L+1][0]){L++;}
			if(output[i][0]==data[L][0]) {G=0;} else {G=1;}
			S=0; if(L-P+G>0){S=L-P+G;}
			E=data.length-1; if(L+P<data.length-1){E=L+P;}
			double[][] vec = new double[E-S+1][2];
			index1=0;
			while(index1<vec.length){
				vec[index1][0]=data[S][0]; vec[index1][1]=data[S][1];
				S++; index1++;
			}
			coefs = LinReg(vec);
			output[i][1]=coefs[0]+output[i][0]*coefs[1];
		}
		return output;
	}
	
	public static double[] LinReg(double[][] vec){
		double[] cc  = {0,0};
		double Xsum  = 0;
		double Ysum  = 0;
		double XYsum = 0;
		double X2sum = 0;
		double Y2sum = 0;
		
		for(int i=0;i<vec.length;i++){
			Xsum=Xsum+vec[i][0];
			Ysum=Ysum+vec[i][1];
			XYsum=XYsum+vec[i][0]*vec[i][1];
			X2sum=X2sum+Math.pow(vec[i][0],2.0);
			Y2sum=Y2sum+Math.pow(vec[i][1],2.0);
		}
		cc[1]=XYsum-(Xsum*Ysum)/vec.length;
		cc[1]=cc[1]/(X2sum-Math.pow(Xsum,2.0)/vec.length);
		cc[0]=Ysum/vec.length-cc[1]*Xsum/vec.length;
		return cc;
	}
	
	public static double[][] monotonic(double[][] input) {
		int marker1 =0;
		int count1  =0;
		int index1  =1;
		double sum1 =0;
		
		// if curve is increasing
		if (input[input.length-1][1]>input[0][1]) {
			while(index1<input.length) {
				while(index1<input.length && input[index1][1]>=input[index1-1][1]){index1++;}
				while(index1<input.length && input[index1][1]<input[index1-1][1]){index1++;}
				count1=1;
				marker1=index1-1;
				while((marker1-count1)>=0 && input[marker1-count1][1]>input[marker1][1]) {
					sum1=input[index1-1][1];
					for (int i=marker1-1;i>=marker1-count1;i--){
						sum1=sum1+input[i][1];
					}
				
					sum1=sum1/(count1+1);
					for(int i=marker1-count1; i<=marker1; i++){
						input[i][1]=sum1;
					}
					count1++;
				}
			}
		}
		else {
			while(index1<input.length){
				while(index1<input.length && input[index1][1]<=input[index1-1][1]){index1++;}
				while(index1<input.length && input[index1][1]>input[index1-1][1]){index1++;}
				count1=1;
				marker1=index1-1;
				while((marker1-count1)>=0 && input[marker1-count1][1]<input[marker1][1]){
				sum1=input[index1-1][1];
					for (int i=marker1-1;i>=marker1-count1;i--){
						sum1=sum1+input[i][1];
					}
				
					sum1=sum1/(count1+1);
					for(int i=marker1-count1; i<=marker1; i++){
						input[i][1]=sum1;
					}
					count1++;
				}
			}
		}	
		return input;
	}
}

	